/*
 * Decompiled with CFR 0.152.
 */
package graphql.scalar;

import graphql.GraphQLContext;
import graphql.Internal;
import graphql.execution.CoercedVariables;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.scalar.CoercingUtil;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Internal
public class GraphqlStringCoercing
implements Coercing<String, String> {
    private String toStringImpl(Object input) {
        return String.valueOf(input);
    }

    private String parseValueImpl(@NotNull Object input, @NotNull Locale locale) {
        if (!(input instanceof String)) {
            throw new CoercingParseValueException(CoercingUtil.i18nMsg(locale, "String.unexpectedRawValueType", CoercingUtil.typeName(input)));
        }
        return (String)input;
    }

    private String parseLiteralImpl(@NotNull Object input, Locale locale) {
        if (!(input instanceof StringValue)) {
            throw new CoercingParseLiteralException(CoercingUtil.i18nMsg(locale, "Scalar.unexpectedAstType", "StringValue", CoercingUtil.typeName(input)));
        }
        return ((StringValue)input).getValue();
    }

    private StringValue valueToLiteralImpl(@NotNull Object input) {
        return StringValue.newStringValue(input.toString()).build();
    }

    @Override
    @Deprecated
    public String serialize(@NotNull Object dataFetcherResult) {
        return this.toStringImpl(dataFetcherResult);
    }

    @Override
    @Nullable
    public String serialize(@NotNull Object dataFetcherResult, @NotNull GraphQLContext graphQLContext, @NotNull Locale locale) throws CoercingSerializeException {
        return this.toStringImpl(dataFetcherResult);
    }

    @Override
    @Deprecated
    public String parseValue(@NotNull Object input) {
        return this.parseValueImpl(input, Locale.getDefault());
    }

    @Override
    public String parseValue(@NotNull Object input, @NotNull GraphQLContext graphQLContext, @NotNull Locale locale) throws CoercingParseValueException {
        return this.parseValueImpl(input, locale);
    }

    @Override
    @Deprecated
    public String parseLiteral(@NotNull Object input) {
        return this.parseLiteralImpl(input, Locale.getDefault());
    }

    @Override
    @Nullable
    public String parseLiteral(@NotNull Value<?> input, @NotNull CoercedVariables variables, @NotNull GraphQLContext graphQLContext, @NotNull Locale locale) throws CoercingParseLiteralException {
        return this.parseLiteralImpl(input, locale);
    }

    @Override
    @Deprecated
    public Value valueToLiteral(@NotNull Object input) {
        return this.valueToLiteralImpl(input);
    }

    @Override
    @NotNull
    public Value<?> valueToLiteral(@NotNull Object input, @NotNull GraphQLContext graphQLContext, @NotNull Locale locale) {
        return this.valueToLiteralImpl(input);
    }
}

