/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder;

import com.healthmarketscience.common.util.AppendableExt;
import com.healthmarketscience.common.util.Appendee;
import com.healthmarketscience.sqlbuilder.ConstraintClause;
import com.healthmarketscience.sqlbuilder.Converter;
import com.healthmarketscience.sqlbuilder.ForeignKeyConstraintClause;
import com.healthmarketscience.sqlbuilder.Query;
import com.healthmarketscience.sqlbuilder.SqlContext;
import com.healthmarketscience.sqlbuilder.SqlObject;
import com.healthmarketscience.sqlbuilder.TypedColumnObject;
import com.healthmarketscience.sqlbuilder.ValidationContext;
import com.healthmarketscience.sqlbuilder.dbspec.Column;
import com.healthmarketscience.sqlbuilder.dbspec.Constraint;
import com.healthmarketscience.sqlbuilder.dbspec.Table;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlterTableQuery
extends Query<AlterTableQuery> {
    private SqlObject _table;
    private SqlObject _action;

    public AlterTableQuery(Table table) {
        this((Object)table);
    }

    public AlterTableQuery(Object tableStr) {
        this._table = Converter.toCustomTableSqlObject(tableStr);
    }

    public AlterTableQuery setAction(Object action) {
        this._action = Converter.toCustomSqlObject(action);
        return this;
    }

    public AlterTableQuery setAddConstraint(Constraint constraint) {
        return this.setAddCustomConstraint(constraint);
    }

    public AlterTableQuery setAddCustomConstraint(Object constraint) {
        return this.setAction((Object)new AddConstraintAction(constraint));
    }

    public AlterTableQuery setAddColumn(Column column) {
        return this.setAddCustomColumn(column);
    }

    public AlterTableQuery setAddCustomColumn(Object column) {
        return this.setAction((Object)new AddColumnAction(column));
    }

    @Override
    protected void collectSchemaObjects(ValidationContext vContext) {
        super.collectSchemaObjects(vContext);
        this._table.collectSchemaObjects(vContext);
        this._action.collectSchemaObjects(vContext);
    }

    @Override
    protected void appendTo(AppendableExt app, SqlContext newContext) throws IOException {
        newContext.setUseTableAliases(false);
        app.append((CharSequence)"ALTER TABLE ").append((Appendee)this._table).append((Appendee)this._action);
    }

    @Deprecated
    public static class AddForeignConstraintAction
    extends AddConstraintAction {
        public AddForeignConstraintAction(Table table) {
            this((Object)table);
        }

        public AddForeignConstraintAction(Object table) {
            super((Object)ConstraintClause.foreignKey(table));
        }

        protected ForeignKeyConstraintClause getConstraint() {
            return (ForeignKeyConstraintClause)super.getConstraint();
        }

        public AddForeignConstraintAction addPrimaryKeyReference(Column col) {
            return this.addReference(col, null);
        }

        public AddForeignConstraintAction addCustomPrimaryKeyReference(Object col) {
            return this.addCustomReference(col, null);
        }

        public AddForeignConstraintAction addReference(Column col, Column referencedCol) {
            return this.addCustomReference(col, referencedCol);
        }

        public AddForeignConstraintAction addCustomReference(Object col, Object referencedCol) {
            this.getConstraint().addCustomColumns(col);
            if (referencedCol != null) {
                this.getConstraint().addCustomRefColumns(referencedCol);
            }
            return this;
        }
    }

    @Deprecated
    public static class AddPrimaryConstraintAction
    extends AddConstraintAction {
        public AddPrimaryConstraintAction() {
            super((Object)ConstraintClause.primaryKey());
        }

        public AddPrimaryConstraintAction addColumns(Column ... columns) {
            return this.addCustomColumns(columns);
        }

        public AddPrimaryConstraintAction addCustomColumns(Object ... columnStrs) {
            this.getConstraint().addCustomColumns(columnStrs);
            return this;
        }
    }

    @Deprecated
    public static class AddUniqueConstraintAction
    extends AddConstraintAction {
        public AddUniqueConstraintAction() {
            super((Object)ConstraintClause.unique());
        }

        public AddUniqueConstraintAction addColumns(Column ... columns) {
            return this.addCustomColumns(columns);
        }

        public AddUniqueConstraintAction addCustomColumns(Object ... columnStrs) {
            this.getConstraint().addCustomColumns(columnStrs);
            return this;
        }
    }

    public static class AddColumnAction
    extends SqlObject {
        private SqlObject _column;

        public AddColumnAction(Object column) {
            this._column = Converter.toCustomTypedColumnSqlObject(column);
        }

        protected void collectSchemaObjects(ValidationContext vContext) {
            this._column.collectSchemaObjects(vContext);
        }

        public void appendTo(AppendableExt app) throws IOException {
            app.append((CharSequence)" ADD ").append((Appendee)this._column);
        }

        public AddColumnAction addConstraint(Object constraint) {
            if (this._column instanceof TypedColumnObject) {
                ((TypedColumnObject)this._column).addConstraint(constraint);
            }
            return this;
        }

        public AddColumnAction setDefaultValue(Object defaultValue) {
            if (this._column instanceof TypedColumnObject) {
                ((TypedColumnObject)this._column).setDefaultValue(defaultValue);
            }
            return this;
        }

        public AddColumnAction setTypeName(String typeName) {
            if (this._column instanceof TypedColumnObject) {
                ((TypedColumnObject)this._column).setTypeName(typeName);
            }
            return this;
        }
    }

    public static class AddConstraintAction
    extends SqlObject {
        protected SqlObject _constraint;

        public AddConstraintAction(Object constraint) {
            this._constraint = Converter.toCustomConstraintClause(constraint);
        }

        protected ConstraintClause getConstraint() {
            return (ConstraintClause)this._constraint;
        }

        protected void collectSchemaObjects(ValidationContext vContext) {
            this._constraint.collectSchemaObjects(vContext);
        }

        public void appendTo(AppendableExt app) throws IOException {
            app.append((CharSequence)" ADD ").append((Appendee)this._constraint);
        }
    }
}

