/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder;

import com.healthmarketscience.common.util.AppendableExt;
import com.healthmarketscience.common.util.Appendee;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.Converter;
import com.healthmarketscience.sqlbuilder.SqlObject;
import com.healthmarketscience.sqlbuilder.ValidationContext;
import com.healthmarketscience.sqlbuilder.ValueObject;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BinaryCondition
extends Condition {
    private Object _binaryOp;
    private SqlObject _leftValue;
    private SqlObject _rightValue;
    private ValueObject _escapeChar;

    public BinaryCondition(Op binaryOp, SqlObject leftValue, SqlObject rightValue) {
        this(binaryOp, (Object)leftValue, (Object)rightValue);
    }

    public BinaryCondition(Op binaryOp, Object leftValue, Object rightValue) {
        this((Object)binaryOp, leftValue, rightValue);
    }

    public BinaryCondition(Object binaryOpStr, Object leftValue, Object rightValue) {
        this._binaryOp = binaryOpStr;
        this._leftValue = Converter.toColumnSqlObject(leftValue);
        this._rightValue = Converter.toColumnSqlObject(rightValue);
    }

    protected void collectSchemaObjects(ValidationContext vContext) {
        this._leftValue.collectSchemaObjects(vContext);
        this._rightValue.collectSchemaObjects(vContext);
    }

    protected boolean supportsEscape(Object binaryOp) {
        return binaryOp == Op.LIKE || binaryOp == Op.NOT_LIKE;
    }

    public BinaryCondition setLikeEscapeChar(Character escapeChar) {
        if (!this.supportsEscape(this._binaryOp)) {
            throw new IllegalArgumentException("Escape char is not valid for '" + this._binaryOp + "' operator");
        }
        this._escapeChar = escapeChar != null ? new ValueObject(escapeChar) : null;
        return this;
    }

    public void appendTo(AppendableExt app) throws IOException {
        this.openParen(app);
        app.append((Appendee)this._leftValue).append(this._binaryOp).append((Appendee)this._rightValue);
        if (this._escapeChar != null) {
            app.append((CharSequence)" ESCAPE ").append((Appendee)this._escapeChar);
        }
        this.closeParen(app);
    }

    public static String escapeLikeLiteral(String literal, char escapeChar) {
        String escapeStr = String.valueOf(escapeChar);
        return literal.replaceAll("([%_" + Pattern.quote(escapeStr) + "])", Matcher.quoteReplacement(escapeStr) + "$1");
    }

    public static BinaryCondition lessThan(Object value1, Object value2, boolean inclusive) {
        return new BinaryCondition(inclusive ? Op.LESS_THAN_OR_EQUAL_TO : Op.LESS_THAN, value1, value2);
    }

    public static BinaryCondition lessThan(Object value1, Object value2) {
        return new BinaryCondition(Op.LESS_THAN, value1, value2);
    }

    public static BinaryCondition lessThanOrEq(Object value1, Object value2) {
        return new BinaryCondition(Op.LESS_THAN_OR_EQUAL_TO, value1, value2);
    }

    public static BinaryCondition greaterThan(Object value1, Object value2, boolean inclusive) {
        return new BinaryCondition(inclusive ? Op.GREATER_THAN_OR_EQUAL_TO : Op.GREATER_THAN, value1, value2);
    }

    public static BinaryCondition greaterThan(Object value1, Object value2) {
        return new BinaryCondition(Op.GREATER_THAN, value1, value2);
    }

    public static BinaryCondition greaterThanOrEq(Object value1, Object value2) {
        return new BinaryCondition(Op.GREATER_THAN_OR_EQUAL_TO, value1, value2);
    }

    public static BinaryCondition equalTo(Object value1, Object value2) {
        return new BinaryCondition(Op.EQUAL_TO, value1, value2);
    }

    public static BinaryCondition notEqualTo(Object value1, Object value2) {
        return new BinaryCondition(Op.NOT_EQUAL_TO, value1, value2);
    }

    public static BinaryCondition like(Object value1, Object value2) {
        return new BinaryCondition(Op.LIKE, value1, value2);
    }

    public static BinaryCondition notLike(Object value1, Object value2) {
        return new BinaryCondition(Op.NOT_LIKE, value1, value2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Op {
        LESS_THAN(" < "),
        LESS_THAN_OR_EQUAL_TO(" <= "),
        GREATER_THAN(" > "),
        GREATER_THAN_OR_EQUAL_TO(" >= "),
        EQUAL_TO(" = "),
        NOT_EQUAL_TO(" <> "),
        LIKE(" LIKE "),
        NOT_LIKE(" NOT LIKE ");

        private final String _opStr;

        private Op(String opStr) {
            this._opStr = opStr;
        }

        public String toString() {
            return this._opStr;
        }
    }
}

