/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder;

import com.healthmarketscience.common.util.AppendableExt;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.Converter;
import com.healthmarketscience.sqlbuilder.SqlObjectList;
import com.healthmarketscience.sqlbuilder.ValidationContext;
import java.io.IOException;

public class ComboCondition
extends Condition {
    private SqlObjectList<Condition> _conditions;

    public ComboCondition(Op comboOp) {
        this(comboOp, (Object[])null);
    }

    public ComboCondition(Op comboOp, Condition ... conditions) {
        this(comboOp, (Object[])conditions);
    }

    public ComboCondition(Op comboOp, Object ... conditions) {
        this((Object)comboOp, conditions);
    }

    public ComboCondition(Object comboOpStr, Object ... conditions) {
        this._conditions = SqlObjectList.create(comboOpStr.toString());
        this._conditions.addObjects(Converter.CUSTOM_TO_CONDITION, conditions);
    }

    protected void collectSchemaObjects(ValidationContext vContext) {
        this._conditions.collectSchemaObjects(vContext);
    }

    public boolean isEmpty() {
        return ComboCondition.areEmpty(this._conditions);
    }

    public boolean hasParens() {
        return ComboCondition.hasParens(this._conditions);
    }

    public ComboCondition addCondition(Condition condition) {
        return this.addCustomConditions(new Object[]{condition});
    }

    public ComboCondition addConditions(Condition ... conditions) {
        return this.addCustomConditions((Object[])conditions);
    }

    public ComboCondition addCustomCondition(Object condition) {
        return this.addCustomConditions(condition);
    }

    public ComboCondition addCustomConditions(Object ... conditions) {
        this._conditions.addObjects(Converter.CUSTOM_TO_CONDITION, conditions);
        return this;
    }

    public void appendTo(AppendableExt app) throws IOException {
        this.appendNestedClauses(app, this._conditions);
    }

    public static ComboCondition and() {
        return new ComboCondition(Op.AND);
    }

    public static ComboCondition and(Condition ... conditions) {
        return ComboCondition.and((Object[])conditions);
    }

    public static ComboCondition and(Object ... conditions) {
        return new ComboCondition(Op.AND, conditions);
    }

    public static ComboCondition or() {
        return new ComboCondition(Op.OR);
    }

    public static ComboCondition or(Condition ... conditions) {
        return ComboCondition.or((Object[])conditions);
    }

    public static ComboCondition or(Object ... conditions) {
        return new ComboCondition(Op.OR, conditions);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Op {
        AND(" AND "),
        OR(" OR ");

        private final String _opStr;

        private Op(String opStr) {
            this._opStr = opStr;
        }

        public String toString() {
            return this._opStr;
        }
    }
}

