/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder;

import com.healthmarketscience.sqlbuilder.AliasedObject;
import com.healthmarketscience.sqlbuilder.BooleanValueObject;
import com.healthmarketscience.sqlbuilder.ColumnObject;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.ConstraintClause;
import com.healthmarketscience.sqlbuilder.ConstraintObject;
import com.healthmarketscience.sqlbuilder.CustomCondition;
import com.healthmarketscience.sqlbuilder.CustomExpression;
import com.healthmarketscience.sqlbuilder.CustomSql;
import com.healthmarketscience.sqlbuilder.Expression;
import com.healthmarketscience.sqlbuilder.FunctionObject;
import com.healthmarketscience.sqlbuilder.IndexObject;
import com.healthmarketscience.sqlbuilder.NumberValueObject;
import com.healthmarketscience.sqlbuilder.SqlObject;
import com.healthmarketscience.sqlbuilder.Subquery;
import com.healthmarketscience.sqlbuilder.TableDefObject;
import com.healthmarketscience.sqlbuilder.TableObject;
import com.healthmarketscience.sqlbuilder.TypedColumnObject;
import com.healthmarketscience.sqlbuilder.ValueObject;
import com.healthmarketscience.sqlbuilder.dbspec.Column;
import com.healthmarketscience.sqlbuilder.dbspec.Constraint;
import com.healthmarketscience.sqlbuilder.dbspec.Function;
import com.healthmarketscience.sqlbuilder.dbspec.Index;
import com.healthmarketscience.sqlbuilder.dbspec.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Converter<SrcType, DstType> {
    public static final Converter<Object, SqlObject> CUSTOM_TO_OBJ = new Converter<Object, SqlObject>(){

        @Override
        public SqlObject convert(Object obj) {
            return 1.toCustomSqlObject(obj);
        }
    };
    public static final Converter<Column, SqlObject> COLUMN_TO_OBJ = new Converter<Column, SqlObject>(){

        @Override
        public SqlObject convert(Column col) {
            return col != null ? new ColumnObject(col) : SqlObject.NULL_VALUE;
        }
    };
    public static final Converter<Object, SqlObject> VALUE_TO_OBJ = new Converter<Object, SqlObject>(){

        @Override
        public SqlObject convert(Object value) {
            return 3.toValueSqlObject(value);
        }
    };
    public static final Converter<Object, SqlObject> COLUMN_VALUE_TO_OBJ = new Converter<Object, SqlObject>(){

        @Override
        public SqlObject convert(Object value) {
            return 4.toColumnSqlObject(value);
        }
    };
    public static final Converter<Object, SqlObject> CUSTOM_COLUMN_TO_OBJ = new Converter<Object, SqlObject>(){

        @Override
        public SqlObject convert(Object value) {
            return 5.toCustomColumnSqlObject(value);
        }
    };
    public static final Converter<Object, Expression> CUSTOM_TO_EXPRESSION = new Converter<Object, Expression>(){

        @Override
        public Expression convert(Object obj) {
            return 6.toExpressionObject(obj);
        }
    };
    public static final Converter<Object, Condition> CUSTOM_TO_CONDITION = new Converter<Object, Condition>(){

        @Override
        public Condition convert(Object obj) {
            return 7.toConditionObject(obj);
        }
    };
    public static final Converter<Object, SqlObject> TYPED_COLUMN_TO_OBJ = new Converter<Object, SqlObject>(){

        @Override
        public SqlObject convert(Object value) {
            return 8.toCustomTypedColumnSqlObject(value);
        }
    };
    public static final Converter<Object, Subquery> CUSTOM_TO_SUBQUERY = new Converter<Object, Subquery>(){

        @Override
        public Subquery convert(Object value) {
            return 9.toSubquery(value);
        }
    };
    public static final Converter<Object, SqlObject> CUSTOM_TO_CONSTRAINTCLAUSE = new Converter<Object, SqlObject>(){

        @Override
        public SqlObject convert(Object value) {
            return 10.toCustomConstraintClause(value);
        }
    };
    public static final Converter<Object, SqlObject> CUSTOM_TABLE_DEF_TO_OBJ = new Converter<Object, SqlObject>(){

        @Override
        public SqlObject convert(Object value) {
            return 11.toCustomTableDefSqlObject(value);
        }
    };

    public abstract DstType convert(SrcType var1);

    public static SqlObject toColumnSqlObject(Column col) {
        return new ColumnObject(col);
    }

    public static SqlObject toColumnSqlObject(Column col, String alias) {
        return AliasedObject.toAliasedObject(Converter.toColumnSqlObject(col), alias);
    }

    public static SqlObject toTableSqlObject(Table table) {
        return new TableObject(table);
    }

    public static SqlObject toConstraintSqlObject(Constraint constraint) {
        return new ConstraintObject(constraint);
    }

    public static SqlObject toTableDefSqlObject(Table table) {
        return new TableDefObject(table);
    }

    public static SqlObject toIndexSqlObject(Index index) {
        return new IndexObject(index);
    }

    public static SqlObject toFunctionSqlObject(Function function) {
        return new FunctionObject(function);
    }

    public static SqlObject toColumnSqlObject(Object obj) {
        if (obj instanceof Column) {
            return Converter.toColumnSqlObject((Column)obj);
        }
        return Converter.toValueSqlObject(obj);
    }

    public static SqlObject toColumnSqlObject(Object obj, String alias) {
        return AliasedObject.toAliasedObject(Converter.toColumnSqlObject(obj), alias);
    }

    public static SqlObject toCustomColumnSqlObject(Object obj) {
        if (obj instanceof Column) {
            return Converter.toColumnSqlObject((Column)obj);
        }
        return Converter.toCustomSqlObject(obj);
    }

    public static SqlObject toCustomColumnSqlObject(Object obj, String alias) {
        return AliasedObject.toAliasedObject(Converter.toCustomColumnSqlObject(obj), alias);
    }

    public static SqlObject toCustomTableSqlObject(Object obj) {
        if (obj instanceof Table) {
            return Converter.toTableSqlObject((Table)obj);
        }
        return Converter.toCustomSqlObject(obj);
    }

    public static SqlObject toCustomConstraintSqlObject(Object obj) {
        if (obj instanceof Constraint) {
            return Converter.toConstraintSqlObject((Constraint)obj);
        }
        if (obj == null) {
            return null;
        }
        return new ConstraintClause.Prefix(Converter.toCustomSqlObject(obj));
    }

    public static SqlObject toCustomIndexSqlObject(Object obj) {
        if (obj instanceof Index) {
            return Converter.toIndexSqlObject((Index)obj);
        }
        return Converter.toCustomSqlObject(obj);
    }

    public static SqlObject toCustomFunctionSqlObject(Object obj) {
        if (obj instanceof Function) {
            return Converter.toFunctionSqlObject((Function)obj);
        }
        return Converter.toCustomSqlObject(obj);
    }

    public static SqlObject toValueSqlObject(Object obj) {
        if (obj == null) {
            return SqlObject.NULL_VALUE;
        }
        if (obj instanceof Boolean) {
            return BooleanValueObject.valueOf((Boolean)obj);
        }
        if (obj instanceof Number) {
            return new NumberValueObject((Number)obj);
        }
        if (obj instanceof SqlObject) {
            return (SqlObject)((Object)obj);
        }
        return new ValueObject(obj);
    }

    public static SqlObject toValueSqlObject(Object obj, String alias) {
        return AliasedObject.toAliasedObject(Converter.toValueSqlObject(obj), alias);
    }

    public static SqlObject toCustomSqlObject(Object obj) {
        SqlObject rtnObj;
        if (obj == null) {
            rtnObj = SqlObject.NULL_VALUE;
        } else if (obj instanceof SqlObject) {
            rtnObj = (SqlObject)((Object)obj);
        } else {
            if (obj instanceof Boolean) {
                return BooleanValueObject.valueOf((Boolean)obj);
            }
            rtnObj = obj instanceof Number ? new NumberValueObject((Number)obj) : new CustomSql(obj);
        }
        return rtnObj;
    }

    public static SqlObject toCustomSqlObject(Object obj, String alias) {
        return AliasedObject.toAliasedObject(Converter.toCustomSqlObject(obj), alias);
    }

    public static SqlObject toCustomTableDefSqlObject(Object table) {
        if (table instanceof Table) {
            return Converter.toTableDefSqlObject((Table)table);
        }
        return Converter.toCustomSqlObject(table);
    }

    public static SqlObject toCustomTypedColumnSqlObject(Object column) {
        if (column instanceof Column) {
            return new TypedColumnObject((Column)column);
        }
        return Converter.toCustomSqlObject(column);
    }

    public static Expression toExpressionObject(Object obj) {
        if (obj instanceof Expression) {
            return (Expression)((Object)obj);
        }
        return (obj = Converter.toColumnSqlObject(obj)) instanceof Expression ? (Expression)((Object)obj) : new CustomExpression(obj);
    }

    public static Condition toConditionObject(Object obj) {
        if (obj instanceof Condition) {
            return (Condition)((Object)obj);
        }
        return new CustomCondition(Converter.toCustomColumnSqlObject(obj));
    }

    public static Subquery toSubquery(Object obj) {
        return obj instanceof Subquery ? (Subquery)((Object)obj) : new Subquery(obj);
    }

    public static SqlObject toCustomConstraintClause(Object obj) {
        if (obj instanceof Constraint) {
            return ConstraintClause.from((Constraint)obj);
        }
        return Converter.toCustomSqlObject(obj);
    }
}

