/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder;

import com.healthmarketscience.common.util.AppendableExt;
import com.healthmarketscience.common.util.Appendee;
import com.healthmarketscience.sqlbuilder.Converter;
import com.healthmarketscience.sqlbuilder.CustomSql;
import com.healthmarketscience.sqlbuilder.Expression;
import com.healthmarketscience.sqlbuilder.SqlObject;
import com.healthmarketscience.sqlbuilder.SqlObjectList;
import com.healthmarketscience.sqlbuilder.ValidationContext;
import com.healthmarketscience.sqlbuilder.dbspec.Column;
import com.healthmarketscience.sqlbuilder.dbspec.Function;
import java.io.IOException;

public class FunctionCall
extends Expression {
    private boolean _isDistinct;
    private SqlObject _functionName;
    private SqlObjectList<SqlObject> _params = SqlObjectList.create();

    public FunctionCall(Function function) {
        this((Object)function);
    }

    public FunctionCall(Object functionNameStr) {
        this._functionName = Converter.toCustomFunctionSqlObject(functionNameStr);
    }

    public boolean hasParens() {
        return false;
    }

    public FunctionCall setIsDistinct(boolean isDistinct) {
        this._isDistinct = isDistinct;
        return this;
    }

    public FunctionCall addCustomParams(Object ... params) {
        this._params.addObjects(Converter.COLUMN_VALUE_TO_OBJ, params);
        return this;
    }

    public FunctionCall addColumnParams(Column ... columns) {
        return this.addCustomParams(columns);
    }

    public FunctionCall addNumericValueParam(Object obj) {
        return this.addCustomParams(obj);
    }

    protected void collectSchemaObjects(ValidationContext vContext) {
        this._functionName.collectSchemaObjects(vContext);
        this._params.collectSchemaObjects(vContext);
    }

    public void appendTo(AppendableExt app) throws IOException {
        app.append((Appendee)this._functionName).append((CharSequence)"(");
        if (this._isDistinct) {
            app.append((CharSequence)"DISTINCT ");
        }
        app.append(this._params).append((CharSequence)")");
    }

    public static FunctionCall avg() {
        return new FunctionCall((Object)new CustomSql("AVG"));
    }

    public static FunctionCall min() {
        return new FunctionCall((Object)new CustomSql("MIN"));
    }

    public static FunctionCall max() {
        return new FunctionCall((Object)new CustomSql("MAX"));
    }

    public static FunctionCall sum() {
        return new FunctionCall((Object)new CustomSql("SUM"));
    }

    public static FunctionCall count() {
        return new FunctionCall((Object)new CustomSql("COUNT"));
    }

    public static FunctionCall countAll() {
        return new FunctionCall((Object)new CustomSql("COUNT")).addCustomParams(new Object[]{ALL_SYMBOL});
    }
}

