/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder;

import com.healthmarketscience.common.util.AppendableExt;
import com.healthmarketscience.sqlbuilder.BaseInsertQuery;
import com.healthmarketscience.sqlbuilder.Converter;
import com.healthmarketscience.sqlbuilder.SqlContext;
import com.healthmarketscience.sqlbuilder.SqlObject;
import com.healthmarketscience.sqlbuilder.SqlObjectList;
import com.healthmarketscience.sqlbuilder.ValidationContext;
import com.healthmarketscience.sqlbuilder.ValidationException;
import com.healthmarketscience.sqlbuilder.dbspec.Column;
import com.healthmarketscience.sqlbuilder.dbspec.Table;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InsertQuery
extends BaseInsertQuery<InsertQuery> {
    private SqlObjectList<SqlObject> _values = SqlObjectList.create();

    public InsertQuery(Table table) {
        this((Object)table);
    }

    public InsertQuery(Object tableStr) {
        super(Converter.toCustomTableSqlObject(tableStr));
    }

    public InsertQuery addCustomColumn(Object columnStr, Object value) {
        return this.addCustomColumns(new Object[]{columnStr}, new Object[]{value});
    }

    public InsertQuery addCustomColumns(Object[] columnStrs, Object[] values) {
        this._columns.addObjects(Converter.CUSTOM_COLUMN_TO_OBJ, columnStrs);
        this._values.addObjects(Converter.VALUE_TO_OBJ, values);
        return this;
    }

    public InsertQuery addColumn(Column column, Object value) {
        return this.addCustomColumn(column, value);
    }

    public InsertQuery addColumns(Column[] columns, Object[] values) {
        return this.addCustomColumns(columns, values);
    }

    public InsertQuery addCustomPreparedColumns(Object ... columnStrs) {
        SqlObject[] values = null;
        if (columnStrs != null) {
            values = new SqlObject[columnStrs.length];
            Arrays.fill((Object[])values, (Object)QUESTION_MARK);
        }
        return this.addCustomColumns(columnStrs, (Object[])values);
    }

    public InsertQuery addPreparedColumns(Column ... columns) {
        return this.addCustomPreparedColumns(columns);
    }

    public InsertQuery addPreparedColumnCollection(Collection<? extends Column> columns) {
        if (columns != null) {
            for (Column column : columns) {
                this.addCustomColumn(column, (Object)QUESTION_MARK);
            }
        }
        return this;
    }

    @Override
    public void validate(ValidationContext vContext) throws ValidationException {
        super.validate(vContext);
        if (this._columns.size() != this._values.size()) {
            throw new ValidationException("mismatched columns and values for insert");
        }
    }

    @Override
    protected void collectSchemaObjects(ValidationContext vContext) {
        super.collectSchemaObjects(vContext);
        this._values.collectSchemaObjects(vContext);
    }

    @Override
    protected void appendTo(AppendableExt app, SqlContext newContext) throws IOException {
        newContext.setUseTableAliases(false);
        this.appendPrefixTo(app);
        app.append((CharSequence)"VALUES (").append(this._values).append((CharSequence)")");
    }
}

