/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder;

import com.healthmarketscience.common.util.AppendableExt;
import com.healthmarketscience.common.util.Appendee;
import com.healthmarketscience.sqlbuilder.SqlObject;
import com.healthmarketscience.sqlbuilder.SqlObjectList;
import java.io.IOException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class NestableClause
extends SqlObject {
    private boolean _disableParens;

    protected NestableClause() {
    }

    public boolean isDisableParens() {
        return this._disableParens;
    }

    public NestableClause setDisableParens(boolean disableParens) {
        this._disableParens = disableParens;
        return this;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean hasParens() {
        return !this.isEmpty() && !this.isDisableParens();
    }

    protected static boolean areEmpty(SqlObjectList<? extends NestableClause> nestedClauses) {
        for (NestableClause nestableClause : nestedClauses) {
            if (nestableClause.isEmpty()) continue;
            return false;
        }
        return true;
    }

    protected static boolean hasParens(SqlObjectList<? extends NestableClause> nestedClauses) {
        int nonEmptyClauses = 0;
        for (NestableClause nestableClause : nestedClauses) {
            if (nestableClause.hasParens()) {
                return true;
            }
            if (nestableClause.isEmpty()) continue;
            ++nonEmptyClauses;
        }
        return nonEmptyClauses > 1;
    }

    protected void openParen(AppendableExt app) throws IOException {
        if (!this.isDisableParens()) {
            app.append((CharSequence)"(");
        }
    }

    protected void closeParen(AppendableExt app) throws IOException {
        if (!this.isDisableParens()) {
            app.append((CharSequence)")");
        }
    }

    protected void appendCustomIfNotNull(AppendableExt app, SqlObject obj) throws IOException {
        if (obj != null) {
            this.openParen(app);
            app.append((Appendee)obj);
            this.closeParen(app);
        }
    }

    protected void appendNestedClauses(AppendableExt app, SqlObjectList<? extends NestableClause> nestedClauses) throws IOException {
        SqlObjectList<NestableClause> tmpNestedClauses;
        boolean hasEmptyNestedClause = false;
        for (NestableClause nestableClause : nestedClauses) {
            if (!nestableClause.isEmpty()) continue;
            hasEmptyNestedClause = true;
            break;
        }
        if (!hasEmptyNestedClause) {
            tmpNestedClauses = nestedClauses;
        } else {
            SqlObjectList sqlObjectList = new SqlObjectList(nestedClauses.getDelimiter(), new ArrayList(nestedClauses.size()));
            for (NestableClause nestableClause : nestedClauses) {
                if (nestableClause.isEmpty()) continue;
                sqlObjectList.addObject(nestableClause);
            }
            tmpNestedClauses = sqlObjectList;
        }
        if (tmpNestedClauses.size() > 1 && !this.isDisableParens()) {
            app.append((CharSequence)"(").append(tmpNestedClauses).append((CharSequence)")");
        } else {
            app.append(tmpNestedClauses);
        }
    }
}

