/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder;

import com.healthmarketscience.common.util.AppendableExt;
import com.healthmarketscience.sqlbuilder.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlContext
implements Cloneable {
    private SqlContext _parent;
    private boolean _useTableAliases = true;
    private boolean _useTableConstraints = true;
    private Query<?> _query;

    public SqlContext getParent() {
        return this._parent;
    }

    private void setParent(SqlContext newParentContext) {
        this._parent = newParentContext;
    }

    public boolean getUseTableAliases() {
        return this._useTableAliases;
    }

    public void setUseTableAliases(boolean newUseTableAliases) {
        this._useTableAliases = newUseTableAliases;
    }

    public boolean getUseTableConstraints() {
        return this._useTableConstraints;
    }

    public void setUseTableConstraints(boolean newUseTableConstraints) {
        this._useTableConstraints = newUseTableConstraints;
    }

    public Query<?> getQuery() {
        return this._query;
    }

    public void setQuery(Query<?> newQuery) {
        this._query = newQuery;
    }

    public SqlContext clone() {
        try {
            return (SqlContext)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("should never get here", e);
        }
    }

    public static SqlContext getContext(AppendableExt app) {
        SqlContext context = (SqlContext)app.getContext();
        if (context == null) {
            context = new SqlContext();
            app.setContext((Object)context);
        }
        return context;
    }

    public static final SqlContext pushContext(AppendableExt app) {
        SqlContext parentContext = (SqlContext)app.getContext();
        SqlContext context = null;
        if (parentContext != null) {
            context = parentContext.clone();
            context.setParent(parentContext);
        } else {
            context = new SqlContext();
        }
        app.setContext((Object)context);
        return context;
    }

    public static void popContext(AppendableExt app, SqlContext context) {
        if (app.getContext() != context) {
            throw new IllegalStateException("Mismatched push/pop SqlContext");
        }
        app.setContext((Object)(context != null ? context.getParent() : null));
    }
}

