/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder;

import com.healthmarketscience.common.util.AppendableExt;
import com.healthmarketscience.common.util.Appendee;
import com.healthmarketscience.sqlbuilder.ColumnObject;
import com.healthmarketscience.sqlbuilder.Converter;
import com.healthmarketscience.sqlbuilder.SqlContext;
import com.healthmarketscience.sqlbuilder.SqlObject;
import com.healthmarketscience.sqlbuilder.SqlObjectList;
import com.healthmarketscience.sqlbuilder.ValidationContext;
import com.healthmarketscience.sqlbuilder.dbspec.Column;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

class TypedColumnObject
extends ColumnObject {
    private String _typeName;
    private SqlObjectList<SqlObject> _constraints = SqlObjectList.create(" ");
    private SqlObject _defaultValue;

    TypedColumnObject(Column column) {
        super(column);
        this._typeName = column.getTypeNameSQL();
        this._constraints.addObjects(Converter.CUSTOM_TO_CONSTRAINTCLAUSE, column.getConstraints());
        Object defVal = column.getDefaultValue();
        if (defVal != null) {
            this._defaultValue = Converter.toValueSqlObject(defVal);
        }
    }

    void setTypeName(String typeName) {
        this._typeName = typeName;
    }

    void addConstraint(Object obj) {
        this._constraints.addObject(Converter.toCustomConstraintClause(obj));
    }

    void setDefaultValue(Object val) {
        this._defaultValue = Converter.toValueSqlObject(val);
    }

    protected void collectSchemaObjects(ValidationContext vContext) {
        super.collectSchemaObjects(vContext);
        this._constraints.collectSchemaObjects(vContext);
        if (this._defaultValue != null) {
            this._defaultValue.collectSchemaObjects(vContext);
        }
    }

    public void appendTo(AppendableExt app) throws IOException {
        app.append((CharSequence)this._column.getColumnNameSQL()).append((CharSequence)" ").append((CharSequence)this._typeName);
        List<?> colQuals = this._column.getTypeQualifiers();
        if (colQuals != null) {
            if (!colQuals.isEmpty()) {
                app.append((CharSequence)"(");
                Iterator<?> iter = colQuals.iterator();
                app.append(iter.next());
                while (iter.hasNext()) {
                    app.append((CharSequence)",").append(iter.next());
                }
                app.append((CharSequence)")");
            }
        } else {
            Integer colFieldLength = this._column.getTypeLength();
            if (colFieldLength != null) {
                app.append((CharSequence)"(").append((Object)colFieldLength).append((CharSequence)")");
            }
        }
        if (this._defaultValue != null) {
            app.append((CharSequence)" DEFAULT ").append((Appendee)this._defaultValue);
        }
        if (!this._constraints.isEmpty()) {
            SqlContext context = SqlContext.pushContext(app);
            context.setUseTableConstraints(false);
            app.append((CharSequence)" ").append(this._constraints);
            SqlContext.popContext(app, context);
        }
    }
}

