/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder.custom.postgresql;

import com.healthmarketscience.common.util.AppendableExt;
import com.healthmarketscience.common.util.Appendee;
import com.healthmarketscience.sqlbuilder.Converter;
import com.healthmarketscience.sqlbuilder.SelectQuery;
import com.healthmarketscience.sqlbuilder.SqlObject;
import com.healthmarketscience.sqlbuilder.ValidationContext;
import com.healthmarketscience.sqlbuilder.ValidationException;
import com.healthmarketscience.sqlbuilder.Verifiable;
import com.healthmarketscience.sqlbuilder.custom.CustomSyntax;
import com.healthmarketscience.sqlbuilder.custom.HookType;
import com.healthmarketscience.sqlbuilder.custom.postgresql.PgLimitClause;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PgOffsetClause
extends CustomSyntax
implements Verifiable<PgOffsetClause> {
    private SqlObject _value;

    public PgOffsetClause(Object value) {
        this._value = Converter.toValueSqlObject(value);
    }

    @Override
    public void apply(SelectQuery query) {
        query.addCustomization(SelectQuery.Hook.FOR_UPDATE, HookType.BEFORE, (Object)this);
    }

    public void appendTo(AppendableExt app) throws IOException {
        app.append((CharSequence)" OFFSET ");
        app.append((Appendee)this._value);
    }

    @Override
    protected void collectSchemaObjects(ValidationContext vContext) {
        vContext.addVerifiable(this);
        PgOffsetClause.collectSchemaObjects(this._value, vContext);
    }

    @Override
    public final PgOffsetClause validate() throws ValidationException {
        this.doValidate();
        return this;
    }

    @Override
    public void validate(ValidationContext vContext) throws ValidationException {
        if (this._value == null) {
            throw new ValidationException("Offset clause is missing row count");
        }
        PgLimitClause.validateValue(this._value, "Offset");
    }
}

