/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder.custom.sqlserver;

import com.healthmarketscience.common.util.AppendableExt;
import com.healthmarketscience.common.util.Appendee;
import com.healthmarketscience.sqlbuilder.Converter;
import com.healthmarketscience.sqlbuilder.SelectQuery;
import com.healthmarketscience.sqlbuilder.SqlObject;
import com.healthmarketscience.sqlbuilder.ValidationContext;
import com.healthmarketscience.sqlbuilder.custom.CustomSyntax;
import com.healthmarketscience.sqlbuilder.custom.HookType;
import java.io.IOException;

public class MssTopClause
extends CustomSyntax {
    private SqlObject _count;
    private boolean _isPercent;

    public MssTopClause(Object count) {
        this(count, false);
    }

    public MssTopClause(Object count, boolean isPercent) {
        this._count = Converter.toValueSqlObject(count);
        this._isPercent = isPercent;
    }

    public MssTopClause setIsPercent(boolean isPercent) {
        this._isPercent = isPercent;
        return this;
    }

    public void apply(SelectQuery query) {
        query.addCustomization(SelectQuery.Hook.DISTINCT, HookType.AFTER, (Object)this);
    }

    public void appendTo(AppendableExt app) throws IOException {
        app.append((CharSequence)"TOP ").append((Appendee)this._count).append((CharSequence)" ");
        if (this._isPercent) {
            app.append((CharSequence)"PERCENT ");
        }
    }

    protected void collectSchemaObjects(ValidationContext vContext) {
        MssTopClause.collectSchemaObjects(this._count, vContext);
    }
}

