/*
 * Decompiled with CFR 0.152.
 */
package net.jpountz.lz4;

import java.nio.ByteOrder;
import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4SafeUtils;
import net.jpountz.util.UnsafeUtils;
import net.jpountz.util.Utils;

final class LZ4UnsafeUtils
extends Enum<LZ4UnsafeUtils> {
    private static final /* synthetic */ LZ4UnsafeUtils[] $VALUES;

    public static LZ4UnsafeUtils[] values() {
        return (LZ4UnsafeUtils[])$VALUES.clone();
    }

    public static LZ4UnsafeUtils valueOf(String string) {
        return Enum.valueOf(LZ4UnsafeUtils.class, string);
    }

    static void safeArraycopy(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        int n5 = n4 & 0xFFFFFFF8;
        LZ4UnsafeUtils.wildArraycopy(byArray, n2, byArray2, n3, n5);
        int n6 = n4 & 7;
        for (int i10 = 0; i10 < n6; ++i10) {
            UnsafeUtils.writeByte(byArray2, n3 + n5 + i10, UnsafeUtils.readByte(byArray, n2 + n5 + i10));
        }
    }

    static void wildArraycopy(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        for (int i10 = 0; i10 < n4; i10 += 8) {
            UnsafeUtils.writeLong(byArray2, n3 + i10, UnsafeUtils.readLong(byArray, n2 + i10));
        }
    }

    static void wildIncrementalCopy(byte[] byArray, int n2, int n3, int n4) {
        if (n3 - n2 < 4) {
            int n5;
            for (n5 = 0; n5 < 4; ++n5) {
                UnsafeUtils.writeByte(byArray, n3 + n5, UnsafeUtils.readByte(byArray, n2 + n5));
            }
            n5 = 0;
            assert ((n3 += 4) >= (n2 += 4) && n3 - n2 < 8);
            switch (n3 - n2) {
                case 1: {
                    n2 -= 3;
                    break;
                }
                case 2: {
                    n2 -= 2;
                    break;
                }
                case 3: {
                    n2 -= 3;
                    n5 = -1;
                    break;
                }
                case 5: {
                    n5 = 1;
                    break;
                }
                case 6: {
                    n5 = 2;
                    break;
                }
                case 7: {
                    n5 = 3;
                    break;
                }
            }
            UnsafeUtils.writeInt(byArray, n3, UnsafeUtils.readInt(byArray, n2));
            n3 += 4;
            n2 -= n5;
        } else if (n3 - n2 < 8) {
            UnsafeUtils.writeLong(byArray, n3, UnsafeUtils.readLong(byArray, n2));
            n3 += n3 - n2;
        }
        while (n3 < n4) {
            UnsafeUtils.writeLong(byArray, n3, UnsafeUtils.readLong(byArray, n2));
            n3 += 8;
            n2 += 8;
        }
    }

    static void safeIncrementalCopy(byte[] byArray, int n2, int n3, int n4) {
        for (int i10 = 0; i10 < n4; ++i10) {
            byArray[n3 + i10] = byArray[n2 + i10];
            UnsafeUtils.writeByte(byArray, n3 + i10, UnsafeUtils.readByte(byArray, n2 + i10));
        }
    }

    static int readShortLittleEndian(byte[] byArray, int n2) {
        short s2 = UnsafeUtils.readShort(byArray, n2);
        if (Utils.NATIVE_BYTE_ORDER == ByteOrder.BIG_ENDIAN) {
            s2 = Short.reverseBytes(s2);
        }
        return s2 & 0xFFFF;
    }

    static void writeShortLittleEndian(byte[] byArray, int n2, int n3) {
        short s2 = (short)n3;
        if (Utils.NATIVE_BYTE_ORDER == ByteOrder.BIG_ENDIAN) {
            s2 = Short.reverseBytes(s2);
        }
        UnsafeUtils.writeShort(byArray, n2, s2);
    }

    static boolean readIntEquals(byte[] byArray, int n2, int n3) {
        return UnsafeUtils.readInt(byArray, n2) == UnsafeUtils.readInt(byArray, n3);
    }

    static int commonBytes(byte[] byArray, int n2, int n3, int n4) {
        int n5 = 0;
        while (n3 <= n4 - 8) {
            if (UnsafeUtils.readLong(byArray, n3) == UnsafeUtils.readLong(byArray, n2)) {
                n5 += 8;
                n2 += 8;
                n3 += 8;
                continue;
            }
            int n6 = Utils.NATIVE_BYTE_ORDER == ByteOrder.BIG_ENDIAN ? Long.numberOfLeadingZeros(UnsafeUtils.readLong(byArray, n3) ^ UnsafeUtils.readLong(byArray, n2)) : Long.numberOfTrailingZeros(UnsafeUtils.readLong(byArray, n3) ^ UnsafeUtils.readLong(byArray, n2));
            return n5 + (n6 >>> 3);
        }
        while (n3 < n4 && UnsafeUtils.readByte(byArray, n2++) == UnsafeUtils.readByte(byArray, n3++)) {
            ++n5;
        }
        return n5;
    }

    static int writeLen(int n2, byte[] byArray, int n3) {
        while (n2 >= 255) {
            UnsafeUtils.writeByte(byArray, n3++, 255);
            n2 -= 255;
        }
        UnsafeUtils.writeByte(byArray, n3++, n2);
        return n3;
    }

    static int encodeSequence(byte[] byArray, int n2, int n3, int n4, int n5, byte[] byArray2, int n6, int n7) {
        int n8;
        int n9 = n3 - n2;
        int n10 = n6++;
        if (n9 >= 15) {
            n8 = -16;
            n6 = LZ4UnsafeUtils.writeLen(n9 - 15, byArray2, n6);
        } else {
            n8 = n9 << 4;
        }
        LZ4UnsafeUtils.wildArraycopy(byArray, n2, byArray2, n6, n9);
        n6 += n9;
        int n11 = n3 - n4;
        byArray2[n6++] = (byte)n11;
        byArray2[n6++] = (byte)(n11 >>> 8);
        if (n6 + 6 + ((n5 -= 4) >>> 8) > n7) {
            throw new LZ4Exception("maxDestLen is too small");
        }
        if (n5 >= 15) {
            n8 |= 0xF;
            n6 = LZ4UnsafeUtils.writeLen(n5 - 15, byArray2, n6);
        } else {
            n8 |= n5;
        }
        byArray2[n10] = (byte)n8;
        return n6;
    }

    static int commonBytesBackward(byte[] byArray, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        while (n2 > n4 && n3 > n5 && UnsafeUtils.readByte(byArray, --n2) == UnsafeUtils.readByte(byArray, --n3)) {
            ++n6;
        }
        return n6;
    }

    static int lastLiterals(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5) {
        return LZ4SafeUtils.lastLiterals(byArray, n2, n3, byArray2, n4, n5);
    }

    static {
        $VALUES = new LZ4UnsafeUtils[0];
    }
}

