/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.msg.base;

import com.intelligt.modbus.jlibmodbus.data.DataHolder;
import com.intelligt.modbus.jlibmodbus.exception.ModbusNumberException;
import com.intelligt.modbus.jlibmodbus.msg.ModbusMessageFactory;
import com.intelligt.modbus.jlibmodbus.msg.ModbusResponseFactory;
import com.intelligt.modbus.jlibmodbus.msg.base.ModbusMessage;
import com.intelligt.modbus.jlibmodbus.msg.base.ModbusResponse;
import com.intelligt.modbus.jlibmodbus.net.stream.base.ModbusOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public abstract class ModbusRequest
extends ModbusMessage
implements ModbusMessageFactory {
    private final ModbusResponse response;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModbusRequest() {
        ModbusResponse response = null;
        try {
            Constructor<?>[] constructors;
            for (Constructor<?> c : constructors = this.getResponseClass().getConstructors()) {
                if (c.getParameterTypes().length != 0) continue;
                response = (ModbusResponse)c.newInstance(new Object[0]);
                break;
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        finally {
            this.response = response;
        }
    }

    @Override
    public void setServerAddress(int serverAddress) throws ModbusNumberException {
        super.setServerAddress(serverAddress);
        this.getResponse().setServerAddress(serverAddress);
    }

    public ModbusResponse getResponse() {
        return this.response;
    }

    protected abstract Class getResponseClass();

    public abstract void writeRequest(ModbusOutputStream var1) throws IOException;

    @Override
    public final void writePDU(ModbusOutputStream fifo) throws IOException {
        fifo.write(this.getFunction());
        this.writeRequest(fifo);
    }

    @Override
    protected final int pduSize() {
        return 1 + this.requestSize();
    }

    public abstract int requestSize();

    public abstract ModbusResponse process(DataHolder var1) throws ModbusNumberException;

    protected abstract boolean validateResponseImpl(ModbusResponse var1);

    public void validateResponse(ModbusResponse msg) throws ModbusNumberException {
        if (this.getProtocolId() != msg.getProtocolId()) {
            throw new ModbusNumberException("Collision: does not matches the transaction id");
        }
        if (this.getTransactionId() != msg.getTransactionId()) {
            throw new ModbusNumberException("Collision: does not matches the transaction id");
        }
        if (this.getServerAddress() != msg.getServerAddress()) {
            throw new ModbusNumberException("Does not matches the slave address", msg.getServerAddress());
        }
        if (this.getFunction() != msg.getFunction()) {
            throw new ModbusNumberException("Does not matches the function code", msg.getFunction());
        }
        if (!msg.isException() && !this.validateResponseImpl(msg)) {
            throw new ModbusNumberException("Collision: response does not matches the request");
        }
    }

    @Override
    public ModbusMessage createMessage(int functionCode) {
        if (functionCode != this.getFunction()) {
            return ModbusResponseFactory.getInstance().createMessage(functionCode);
        }
        return this.getResponse();
    }
}

