/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.msg.base;

import com.intelligt.modbus.jlibmodbus.exception.ModbusNumberException;
import com.intelligt.modbus.jlibmodbus.msg.base.ModbusMessage;
import com.intelligt.modbus.jlibmodbus.net.stream.base.ModbusInputStream;
import com.intelligt.modbus.jlibmodbus.net.stream.base.ModbusOutputStream;
import com.intelligt.modbus.jlibmodbus.utils.ModbusExceptionCode;
import com.intelligt.modbus.jlibmodbus.utils.ModbusFunctionCode;
import java.io.IOException;

public abstract class ModbusResponse
extends ModbusMessage {
    private volatile ModbusExceptionCode modbusExceptionCode = ModbusExceptionCode.NO_EXCEPTION;

    protected ModbusResponse() {
    }

    public final boolean isException() {
        return this.getModbusExceptionCode() != ModbusExceptionCode.NO_EXCEPTION;
    }

    public final void setException() {
        this.modbusExceptionCode = ModbusExceptionCode.UNKNOWN_EXCEPTION;
    }

    @Override
    protected final void writePDU(ModbusOutputStream fifo) throws IOException {
        if (this.isException()) {
            fifo.write(ModbusFunctionCode.getExceptionValue(this.getFunction()));
            fifo.write(this.getModbusExceptionCode().getValue());
        } else {
            fifo.write(this.getFunction());
            this.writeResponse(fifo);
        }
    }

    @Override
    public final void readPDU(ModbusInputStream fifo) throws IOException, ModbusNumberException {
        if (this.isException()) {
            this.setModbusExceptionCode(fifo.read());
        } else {
            this.readResponse(fifo);
        }
    }

    protected abstract void readResponse(ModbusInputStream var1) throws IOException, ModbusNumberException;

    protected abstract void writeResponse(ModbusOutputStream var1) throws IOException;

    public final ModbusExceptionCode getModbusExceptionCode() {
        return this.modbusExceptionCode;
    }

    public final void setModbusExceptionCode(int code) {
        this.modbusExceptionCode = ModbusExceptionCode.get(code);
    }

    @Override
    protected final int pduSize() {
        return 1 + this.responseSize();
    }

    protected abstract int responseSize();
}

