/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.serial;

import com.intelligt.modbus.jlibmodbus.Modbus;
import com.intelligt.modbus.jlibmodbus.net.stream.InputStreamTCP;
import com.intelligt.modbus.jlibmodbus.net.stream.OutputStreamTCP;
import com.intelligt.modbus.jlibmodbus.serial.SerialParameters;
import com.intelligt.modbus.jlibmodbus.serial.SerialPort;
import com.intelligt.modbus.jlibmodbus.serial.SerialPortAbstractFactory;
import com.intelligt.modbus.jlibmodbus.serial.SerialPortException;
import com.intelligt.modbus.jlibmodbus.tcp.TcpParameters;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.LinkedList;
import java.util.List;

public class SerialPortFactoryTcpServer
extends SerialPortAbstractFactory {
    private final TcpParameters tcpParameters;

    public SerialPortFactoryTcpServer(TcpParameters tcpParameters) {
        super(SerialPortFactoryTcpServer.class.getCanonicalName(), "tcp-server");
        this.tcpParameters = tcpParameters;
    }

    public TcpParameters getTcpParameters() {
        return this.tcpParameters;
    }

    @Override
    public SerialPort createSerialImpl(SerialParameters sp) {
        return new SerialPortTcpServer(sp);
    }

    @Override
    public List<String> getPortIdentifiersImpl() {
        return new LinkedList<String>();
    }

    class SerialPortTcpServer
    extends SerialPort
    implements Runnable {
        volatile boolean listening;
        private Thread mainThread;
        private ServerSocket server;
        private Socket client;
        private InputStreamTCP is;
        private OutputStreamTCP os;
        private int timeout;

        SerialPortTcpServer(SerialParameters sp) {
            super(sp);
            this.listening = false;
            this.mainThread = null;
            this.server = null;
            this.client = null;
            this.is = null;
            this.os = null;
            this.timeout = 1000;
        }

        public int getTimeout() {
            return this.timeout;
        }

        public void setTimeout(int timeout) {
            this.timeout = timeout;
        }

        private boolean isListening() {
            return this.listening;
        }

        private void setListening(boolean listening) {
            this.listening = listening;
        }

        @Override
        public void open() throws SerialPortException {
            try {
                this.server = new ServerSocket(SerialPortFactoryTcpServer.this.getTcpParameters().getPort());
                this.mainThread = new Thread(this);
                this.setListening(true);
                this.mainThread.start();
            }
            catch (IOException e) {
                throw new SerialPortException(e);
            }
        }

        @Override
        public void write(byte[] b) throws IOException {
            if (!this.isOpened()) {
                throw new IOException("Port not opened");
            }
            this.os.write(b);
            this.os.flush();
        }

        @Override
        public void write(int b) throws IOException {
            if (!this.isOpened()) {
                throw new IOException("Port not opened");
            }
            this.os.write(b);
            this.os.flush();
        }

        @Override
        public int read() throws IOException {
            if (this.isOpened()) {
                return this.is.read();
            }
            throw new IOException("Port not opened");
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.isOpened()) {
                return this.is.read(b, off, len);
            }
            throw new IOException("Port not opened");
        }

        @Override
        public void close() {
            this.setListening(false);
            try {
                if (this.server != null) {
                    this.server.close();
                }
            }
            catch (IOException e) {
                Modbus.log().warning(e.getLocalizedMessage());
            }
            finally {
                this.server = null;
            }
            try {
                if (this.mainThread != null) {
                    this.mainThread.join(this.timeout * 2);
                    if (this.mainThread.isAlive()) {
                        this.mainThread.interrupt();
                    }
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            finally {
                this.mainThread = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setReadTimeout(int readTimeout) {
            this.setTimeout(readTimeout);
            SerialPortTcpServer serialPortTcpServer = this;
            synchronized (serialPortTcpServer) {
                if (this.isOpened()) {
                    super.setReadTimeout(readTimeout);
                    try {
                        this.client.setSoTimeout(readTimeout);
                    }
                    catch (SocketException e) {
                        e.printStackTrace();
                        Modbus.log().warning("Unable to set readTimeout: " + e.getLocalizedMessage());
                    }
                }
            }
        }

        @Override
        public boolean isOpened() {
            return this.client != null && this.client.isConnected() && this.os != null && this.is != null;
        }

        @Override
        public void run() {
            try {
                while (this.isListening()) {
                    this.client = this.server.accept();
                    this.is = new InputStreamTCP(this.client);
                    this.os = new OutputStreamTCP(this.client);
                    while (this.client.isConnected() && this.isListening()) {
                        Thread.sleep(this.timeout);
                    }
                }
            }
            catch (SocketException e) {
                if (this.server != null && !this.server.isClosed()) {
                    Modbus.log().warning(e.getLocalizedMessage());
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

