/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.api.Spaceable;
import com.itextpdf.text.pdf.ColumnText;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfDiv;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatLayout {
    protected float maxY;
    protected float minY;
    protected float leftX;
    protected float rightX;
    protected float yLine;
    protected float floatLeftX;
    protected float floatRightX;
    protected float filledWidth;
    protected final ColumnText compositeColumn;
    protected final List<Element> content;

    public float getYLine() {
        return this.yLine;
    }

    public void setYLine(float yLine) {
        this.yLine = yLine;
    }

    public float getFilledWidth() {
        return this.filledWidth;
    }

    public void setFilledWidth(float filledWidth) {
        this.filledWidth = filledWidth;
    }

    public FloatLayout(ColumnText compositeColumn, List<Element> elements) {
        this.compositeColumn = ColumnText.duplicate(compositeColumn);
        this.content = elements;
    }

    public FloatLayout(PdfContentByte canvas, List<Element> elements) {
        this.compositeColumn = new ColumnText(canvas);
        this.compositeColumn.setUseAscender(false);
        this.content = elements;
    }

    public void setSimpleColumn(float llx, float lly, float urx, float ury) {
        this.leftX = Math.min(llx, urx);
        this.maxY = Math.max(lly, ury);
        this.minY = Math.min(lly, ury);
        this.rightX = Math.max(llx, urx);
        this.floatLeftX = this.leftX;
        this.floatRightX = this.rightX;
        this.yLine = this.maxY;
        this.filledWidth = 0.0f;
    }

    public int layout(boolean simulate) throws DocumentException {
        List<Element> content;
        int status = 1;
        this.filledWidth = 0.0f;
        ArrayList<Element> floatingElements = new ArrayList<Element>();
        List<Element> list = content = simulate ? new ArrayList<Element>(this.content) : this.content;
        while (!content.isEmpty()) {
            if (content.get(0) instanceof PdfDiv) {
                PdfDiv floatingElement = (PdfDiv)content.get(0);
                if (floatingElement.getFloatType() == PdfDiv.FloatType.LEFT || floatingElement.getFloatType() == PdfDiv.FloatType.RIGHT) {
                    floatingElements.add(floatingElement);
                    content.remove(0);
                    continue;
                }
                if (!floatingElements.isEmpty() && ((status = this.floatingLayout(this.compositeColumn, floatingElements, simulate)) & 1) == 0) break;
                content.remove(0);
                status = floatingElement.layout(this.compositeColumn, true, this.floatLeftX, this.minY, this.floatRightX, this.yLine);
                if (!simulate) {
                    status = floatingElement.layout(this.compositeColumn, simulate, this.floatLeftX, this.minY, this.floatRightX, this.yLine);
                }
                this.yLine -= floatingElement.getActualHeight();
                if (floatingElement.getActualWidth() > this.filledWidth) {
                    this.filledWidth = floatingElement.getActualWidth();
                }
                if ((status & 1) != 0) continue;
                content.add(0, floatingElement);
                break;
            }
            floatingElements.add(content.get(0));
            content.remove(0);
        }
        if (status & true && !floatingElements.isEmpty()) {
            status = this.floatingLayout(this.compositeColumn, floatingElements, simulate);
        }
        content.addAll(0, floatingElements);
        return status;
    }

    private int floatingLayout(ColumnText compositeColumn, List<Element> floatingElements, boolean simulate) throws DocumentException {
        int status = 1;
        float minYLine = this.yLine;
        float leftWidth = 0.0f;
        float rightWidth = 0.0f;
        while (!floatingElements.isEmpty()) {
            if (floatingElements.get(0) instanceof PdfDiv) {
                PdfDiv floatingElement = (PdfDiv)floatingElements.get(0);
                floatingElements.remove(0);
                status = floatingElement.layout(compositeColumn, true, this.floatLeftX, this.minY, this.floatRightX, this.yLine);
                if ((status & 1) == 0) {
                    this.yLine = minYLine;
                    this.floatLeftX = this.leftX;
                    this.floatRightX = this.rightX;
                    status = floatingElement.layout(compositeColumn, true, this.floatLeftX, this.minY, this.floatRightX, this.yLine);
                    if ((status & 1) == 0) {
                        floatingElements.add(0, floatingElement);
                        break;
                    }
                }
                if (floatingElement.getFloatType() == PdfDiv.FloatType.LEFT) {
                    status = floatingElement.layout(compositeColumn, simulate, this.floatLeftX, this.minY, this.floatRightX, this.yLine);
                    this.floatLeftX += floatingElement.getActualWidth();
                    leftWidth += floatingElement.getActualWidth();
                } else if (floatingElement.getFloatType() == PdfDiv.FloatType.RIGHT) {
                    status = floatingElement.layout(compositeColumn, simulate, this.floatRightX - floatingElement.getActualWidth() - 0.01f, this.minY, this.floatRightX, this.yLine);
                    this.floatRightX -= floatingElement.getActualWidth();
                    rightWidth += floatingElement.getActualWidth();
                }
                minYLine = Math.min(minYLine, this.yLine - floatingElement.getActualHeight());
                continue;
            }
            Element firstElement = floatingElements.get(0);
            if (firstElement instanceof Spaceable) {
                this.yLine -= ((Spaceable)((Object)firstElement)).getSpacingBefore();
            }
            compositeColumn = simulate ? ColumnText.duplicate(compositeColumn) : compositeColumn;
            compositeColumn.addElement(firstElement);
            floatingElements.remove(0);
            if (this.yLine > minYLine) {
                compositeColumn.setSimpleColumn(this.floatLeftX, this.yLine, this.floatRightX, minYLine);
            } else {
                compositeColumn.setSimpleColumn(this.floatLeftX, this.yLine, this.floatRightX, this.minY);
            }
            compositeColumn.setFilledWidth(0.0f);
            status = compositeColumn.go(simulate);
            if (this.yLine > minYLine && (this.floatLeftX > this.leftX || this.floatRightX < this.rightX) && (status & 1) == 0) {
                this.yLine = minYLine;
                this.floatLeftX = this.leftX;
                this.floatRightX = this.rightX;
                if (leftWidth != 0.0f && rightWidth != 0.0f) {
                    this.filledWidth = this.rightX - this.leftX;
                } else {
                    if (leftWidth > this.filledWidth) {
                        this.filledWidth = leftWidth;
                    }
                    if (rightWidth > this.filledWidth) {
                        this.filledWidth = rightWidth;
                    }
                }
                leftWidth = 0.0f;
                rightWidth = 0.0f;
                compositeColumn.setSimpleColumn(this.floatLeftX, this.yLine, this.floatRightX, this.minY);
                status = compositeColumn.go(simulate);
                this.yLine = minYLine = compositeColumn.getYLine() + compositeColumn.getDescender();
                if (compositeColumn.getFilledWidth() > this.filledWidth) {
                    this.filledWidth = compositeColumn.getFilledWidth();
                }
            } else {
                if (rightWidth > 0.0f) {
                    rightWidth += compositeColumn.getFilledWidth();
                } else if (leftWidth > 0.0f) {
                    leftWidth += compositeColumn.getFilledWidth();
                } else if (compositeColumn.getFilledWidth() > this.filledWidth) {
                    this.filledWidth = compositeColumn.getFilledWidth();
                }
                minYLine = Math.min(compositeColumn.getYLine() + compositeColumn.getDescender(), minYLine);
                this.yLine = compositeColumn.getYLine() + compositeColumn.getDescender();
            }
            if ((status & 1) == 0) {
                if (!simulate) {
                    floatingElements.addAll(0, compositeColumn.getCompositeElements());
                } else {
                    floatingElements.add(0, firstElement);
                }
                compositeColumn.getCompositeElements().clear();
                break;
            }
            compositeColumn.getCompositeElements().clear();
        }
        if (leftWidth != 0.0f && rightWidth != 0.0f) {
            this.filledWidth = this.rightX - this.leftX;
        } else {
            if (leftWidth > this.filledWidth) {
                this.filledWidth = leftWidth;
            }
            if (rightWidth > this.filledWidth) {
                this.filledWidth = rightWidth;
            }
        }
        this.yLine = minYLine;
        this.floatLeftX = this.leftX;
        this.floatRightX = this.rightX;
        return status;
    }
}

