/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.css.validate.impl.datatype;

import com.itextpdf.styledxmlparser.css.CommonCssConstants;
import com.itextpdf.styledxmlparser.css.util.CssBackgroundUtils;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import com.itextpdf.styledxmlparser.css.validate.ICssDataTypeValidator;
import java.util.List;

public class CssBackgroundValidator
implements ICssDataTypeValidator {
    private static final int MAX_AMOUNT_OF_VALUES = 2;
    private final String backgroundProperty;

    public CssBackgroundValidator(String backgroundProperty) {
        this.backgroundProperty = backgroundProperty;
    }

    @Override
    public boolean isValid(String objectString) {
        if (objectString == null) {
            return false;
        }
        if (CssUtils.isInitialOrInheritOrUnset(objectString)) {
            return true;
        }
        List<List<String>> extractedProperties = CssUtils.extractShorthandProperties(objectString);
        for (List<String> propertyValues : extractedProperties) {
            if (propertyValues.isEmpty() || propertyValues.size() > 2) {
                return false;
            }
            for (int i = 0; i < propertyValues.size(); ++i) {
                if (this.isValidProperty(propertyValues, i)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isValidProperty(List<String> propertyValues, int index) {
        if (this.isPropertyValueCorrespondsPropertyType(propertyValues.get(index))) {
            if (propertyValues.size() == 2) {
                if (this.isMultiValueAllowedForThisType() && CssBackgroundValidator.isMultiValueAllowedForThisValue(propertyValues.get(index))) {
                    return this.checkMultiValuePositionXY(propertyValues, index);
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean checkMultiValuePositionXY(List<String> propertyValues, int index) {
        if ("background-position-x".equals(this.backgroundProperty) || "background-position-y".equals(this.backgroundProperty)) {
            if (CommonCssConstants.BACKGROUND_POSITION_VALUES.contains(propertyValues.get(index)) && index == 1) {
                return false;
            }
            return CommonCssConstants.BACKGROUND_POSITION_VALUES.contains(propertyValues.get(index)) || index == 1;
        }
        return true;
    }

    private boolean isMultiValueAllowedForThisType() {
        return !"background-origin".equals(this.backgroundProperty) && !"background-clip".equals(this.backgroundProperty) && !"background-image".equals(this.backgroundProperty) && !"background-attachment".equals(this.backgroundProperty);
    }

    private static boolean isMultiValueAllowedForThisValue(String value) {
        return !"repeat-x".equals(value) && !"repeat-y".equals(value) && !"cover".equals(value) && !"contain".equals(value) && !"center".equals(value);
    }

    private boolean isPropertyValueCorrespondsPropertyType(String value) {
        CssBackgroundUtils.BackgroundPropertyType propertyType = CssBackgroundUtils.resolveBackgroundPropertyType(value);
        if (propertyType == CssBackgroundUtils.BackgroundPropertyType.UNDEFINED) {
            return false;
        }
        if (CssBackgroundUtils.getBackgroundPropertyNameFromType(propertyType).equals(this.backgroundProperty)) {
            return true;
        }
        if (propertyType == CssBackgroundUtils.BackgroundPropertyType.BACKGROUND_POSITION && ("background-position-x".equals(this.backgroundProperty) || "background-position-y".equals(this.backgroundProperty))) {
            return true;
        }
        if (propertyType == CssBackgroundUtils.BackgroundPropertyType.BACKGROUND_ORIGIN_OR_CLIP && ("background-clip".equals(this.backgroundProperty) || "background-origin".equals(this.backgroundProperty))) {
            return true;
        }
        return propertyType == CssBackgroundUtils.BackgroundPropertyType.BACKGROUND_POSITION_OR_SIZE && ("background-position-x".equals(this.backgroundProperty) || "background-position-y".equals(this.backgroundProperty) || "background-size".equals(this.backgroundProperty));
    }
}

