/*
 * Decompiled with CFR 0.152.
 */
package com.jdcloud.sdk.auth;

import com.jdcloud.sdk.auth.Credentials;
import com.jdcloud.sdk.utils.Validate;
import java.util.Objects;

public class SessionCredentials
extends Credentials {
    private final String sessionToken;

    public SessionCredentials(String accessKey, String secretKey, String sessionToken) {
        super(accessKey, secretKey);
        this.sessionToken = Validate.notNull(sessionToken, "Session token cannot be null.", new Object[0]);
    }

    public final String sessionToken() {
        return this.sessionToken;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.accessKeyId() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SessionCredentials that = (SessionCredentials)o;
        return Objects.equals(this.sessionToken, that.sessionToken);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.sessionToken);
    }
}

