/*
 * Decompiled with CFR 0.152.
 */
package com.jdcloud.sdk.client;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.apache.ApacheHttpTransport;
import com.jdcloud.sdk.auth.CredentialsProvider;
import com.jdcloud.sdk.client.Environment;
import com.jdcloud.sdk.http.HttpRequestConfig;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public abstract class JdcloudClient {
    HttpTransport httpTransport = new ApacheHttpTransport();
    HttpRequestFactory httpRequestFactory;
    private Map<String, String> customHeader = new HashMap<String, String>();
    public static final Feature[] FEATURES = new Feature[]{Feature.AutoCloseSource, Feature.UseBigDecimal, Feature.AllowUnQuotedFieldNames, Feature.AllowSingleQuotes, Feature.AllowArbitraryCommas, Feature.AllowArbitraryCommas, Feature.SortFeidFastMatch, Feature.IgnoreNotMatch};

    void init() {
        this.httpRequestFactory = this.httpTransport.createRequestFactory(new HttpRequestInitializer(){

            public void initialize(HttpRequest request) throws IOException {
                HttpRequestConfig httpRequestConfig = JdcloudClient.this.getHttpRequestConfig();
                if (httpRequestConfig != null) {
                    if (httpRequestConfig.getConnectionTimeout() != -1) {
                        request.setConnectTimeout(httpRequestConfig.getConnectionTimeout());
                    }
                    if (httpRequestConfig.getSocketTimeout() != -1) {
                        request.setReadTimeout(httpRequestConfig.getSocketTimeout());
                    }
                }
            }
        });
    }

    HttpRequest buildRequest(String requestMethod, GenericUrl url, HttpContent content) throws IOException {
        return this.httpRequestFactory.buildRequest(requestMethod, url, content);
    }

    <T> T readValue(InputStream src, Class<T> valueType) throws IOException {
        if (src == null) {
            return null;
        }
        return (T)JSON.parseObject((InputStream)src, valueType, (Feature[])FEATURES);
    }

    <T> T readValue(byte[] src, Class<T> valueType) throws IOException {
        if (src == null) {
            return null;
        }
        return (T)JSON.parseObject((byte[])src, valueType, (Feature[])FEATURES);
    }

    String readValue(InputStream src) throws IOException {
        int length;
        if (src == null) {
            return null;
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = src.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        return result.toString();
    }

    <T> T readValue(String text, Class<T> valueType) {
        return (T)JSON.parseObject((String)text, valueType, (Feature[])FEATURES);
    }

    String getEndpoint() {
        Environment environment = this.getEnvironment();
        if (environment != null) {
            return environment.getEndpoint();
        }
        return null;
    }

    String getRealEndPoints() {
        Environment environment = this.getEnvironment();
        if (environment != null) {
            return environment.getRealEndPoints();
        }
        return null;
    }

    public abstract CredentialsProvider getCredentialsProvider();

    public abstract HttpRequestConfig getHttpRequestConfig();

    public abstract Environment getEnvironment();

    public abstract String getUserAgent();

    public abstract String getServiceName();

    public abstract String getVersion();

    public abstract String getRegionId();

    public void setCustomHeader(String key, String value) {
        this.customHeader.put(key, value);
    }

    public Map<String, String> getCustomHeader() {
        return this.customHeader;
    }
}

