/*
 * Decompiled with CFR 0.152.
 */
package com.jdcloud.sdk.client;

import com.alibaba.fastjson.JSON;
import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.jdcloud.sdk.JdcloudSdkException;
import com.jdcloud.sdk.annotation.HeaderParameter;
import com.jdcloud.sdk.annotation.QueryParameter;
import com.jdcloud.sdk.annotation.Required;
import com.jdcloud.sdk.auth.sign.SignatureComposer;
import com.jdcloud.sdk.client.JdcloudClient;
import com.jdcloud.sdk.http.ContentType;
import com.jdcloud.sdk.http.SdkHttpMethod;
import com.jdcloud.sdk.model.SignRequest;
import com.jdcloud.sdk.service.JdcloudHttpResponse;
import com.jdcloud.sdk.service.JdcloudRequest;
import com.jdcloud.sdk.service.JdcloudResponse;
import com.jdcloud.sdk.service.JdcloudUnmarshaller;
import com.jdcloud.sdk.utils.Base64Utils;
import com.jdcloud.sdk.utils.BinaryUtils;
import com.jdcloud.sdk.utils.ConvertUtils;
import com.jdcloud.sdk.utils.StringUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JdcloudExecutor {
    private static Logger logger = LoggerFactory.getLogger(JdcloudExecutor.class);
    private static String dateFormat = "yyyy-MM-dd'T'HH:mm:ss";
    private static String charset = "UTF-8";
    private static Pattern pattern = Pattern.compile("\\{([a-zA-Z0-9-_]+)\\}");
    private static Set<String> base64Headers = new HashSet<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("x-jdcloud-security-token");
            this.add("x-jdcloud-pin");
            this.add("x-jdcloud-erp");
        }
    };
    protected JdcloudClient jdcloudClient;

    public abstract String method();

    public abstract String url();

    public abstract Class<? extends JdcloudResponse> returnType();

    public abstract JdcloudUnmarshaller getUnmarshaller();

    public JdcloudExecutor client(JdcloudClient client) {
        this.jdcloudClient = client;
        return this;
    }

    public <R1 extends JdcloudResponse, R2 extends JdcloudRequest> R1 execute(R2 request) {
        this.checkImportantParams();
        this.checkRequest(request);
        HttpResponse httpResponse = null;
        try {
            String uri = this.replaceUrl(this.url(), request);
            StringBuilder host = new StringBuilder().append(this.jdcloudClient.getHttpRequestConfig().getProtocol().toString()).append("://").append(this.jdcloudClient.getEndpoint());
            StringBuilder signingHost = StringUtils.isNotBlank(this.jdcloudClient.getRealEndPoints()) ? new StringBuilder().append(this.jdcloudClient.getHttpRequestConfig().getProtocol().toString()).append("://").append(this.jdcloudClient.getRealEndPoints()) : host;
            String version = this.jdcloudClient.getVersion();
            StringBuilder path = new StringBuilder();
            if (StringUtils.isNotBlank(version)) {
                path.append("/").append(version).append(uri);
            } else {
                path.append(uri);
            }
            StringBuilder params = new StringBuilder(this.getParams(request));
            logger.debug("http request url: {}{}{}", new Object[]{host, path, params});
            String contentType = this.jdcloudClient.getHttpRequestConfig().getContentType().toString();
            ByteArrayContent bodyContent = ConvertUtils.formatRequestBody(contentType, request, this.method());
            if (this.jdcloudClient.httpRequestFactory == null) {
                this.jdcloudClient.init();
            }
            HttpRequest httpRequest = this.jdcloudClient.buildRequest(this.method(), new GenericUrl(host.toString() + path.toString() + params.toString()), (HttpContent)bodyContent);
            httpRequest.getHeaders().setUserAgent(this.jdcloudClient.getUserAgent());
            httpRequest.getHeaders().setContentType(contentType);
            this.setCustomHeader(httpRequest.getHeaders());
            if (this.jdcloudClient.getCredentialsProvider() != null && this.jdcloudClient.getCredentialsProvider().getCredentials() != null && StringUtils.isNotBlank(this.jdcloudClient.getCredentialsProvider().getCredentials().accessKeyId()) && StringUtils.isNotBlank(this.jdcloudClient.getCredentialsProvider().getCredentials().secretAccessKey())) {
                String regionId = this.jdcloudClient.getRegionId();
                if (StringUtils.isBlank(regionId)) {
                    regionId = request.getRegionId();
                }
                SignRequest signRequest = new SignRequest(signingHost.toString(), path.toString(), regionId, this.jdcloudClient.getServiceName(), httpRequest, this.jdcloudClient.getCredentialsProvider().getCredentials());
                SignatureComposer signer = new SignatureComposer();
                signer.sign(signRequest);
                logger.debug("Authorization: {}", (Object)httpRequest.getHeaders().getAuthorization());
            }
            httpResponse = httpRequest.execute();
            JdcloudResponse jdcloudResponse = this.handlerHttpResponse(httpResponse);
            return (R1)jdcloudResponse;
        }
        catch (HttpResponseException e) {
            logger.error(e.getContent());
            if (e.getContent() == null) {
                throw new JdcloudSdkException(e);
            }
            JdcloudResponse response = e.getContent().indexOf("[gw]") > 0 ? (JdcloudResponse)JSON.parseObject((String)e.getContent(), this.returnType()) : this.getUnmarshaller().unmarshall(e.getContent(), null);
            if (null == response) {
                throw new JdcloudSdkException("Illegal Content");
            }
            JdcloudResponse jdcloudResponse = response;
            return (R1)jdcloudResponse;
        }
        catch (Exception e) {
            throw new JdcloudSdkException(e);
        }
        finally {
            if (httpResponse != null) {
                try {
                    httpResponse.disconnect();
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
            }
        }
    }

    public String replaceUrl(String httpUrl, JdcloudRequest request) {
        if (httpUrl == null || httpUrl.length() == 0) {
            return "";
        }
        if (httpUrl.indexOf(123) < 0) {
            return httpUrl;
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().setDateFormat(dateFormat).create();
        JsonElement jsonElement = gson.toJsonTree((Object)request);
        Matcher matcher = pattern.matcher(httpUrl);
        StringBuffer url = new StringBuffer();
        while (matcher.find()) {
            String fieldName = matcher.group(1);
            matcher.appendReplacement(url, this.getRequestValue(fieldName, jsonElement));
        }
        matcher.appendTail(url);
        return url.toString();
    }

    private void checkRequest(Object request) {
        Field[] array = request.getClass().getDeclaredFields();
        try {
            for (Field field : array) {
                Object value;
                if (field.isAnnotationPresent(Required.class)) {
                    field.setAccessible(true);
                    value = field.get(request);
                    if (value != null) continue;
                    logger.info("{} not set", (Object)field.getName());
                    throw new JdcloudSdkException(field.getName() + " not set");
                }
                if (!field.isAnnotationPresent(HeaderParameter.class)) continue;
                field.setAccessible(true);
                value = field.get(request);
                if (value == null || !StringUtils.isNotBlank(value.toString()) || !(request instanceof JdcloudRequest)) continue;
                this.jdcloudClient.setCustomHeader(field.getName(), value.toString());
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new JdcloudSdkException(e);
        }
    }

    protected void checkImportantParams() {
        if (this.jdcloudClient == null) {
            throw new JdcloudSdkException("jdcloudClient not set.");
        }
        if (this.jdcloudClient.getEndpoint() == null || this.jdcloudClient.getEndpoint().length() == 0) {
            throw new JdcloudSdkException("endpoint not set.");
        }
        if (this.jdcloudClient.getServiceName() == null) {
            throw new JdcloudSdkException("serviceName not set.");
        }
    }

    protected JdcloudResponse handlerHttpResponse(HttpResponse httpResponse) throws IOException, IllegalAccessException, InstantiationException, JAXBException {
        Object o;
        String reqId = null;
        if (httpResponse.getHeaders() != null && (o = httpResponse.getHeaders().get((Object)"x-jdcloud-request-id")) instanceof ArrayList) {
            reqId = (String)((ArrayList)o).get(0);
        }
        JdcloudResponse response = this.returnType().newInstance();
        ContentType contentType = this.getContentType(httpResponse.getContentType());
        byte[] content = null;
        if (httpResponse.getContent() != null && httpResponse.getStatusCode() != 204 && httpResponse.getStatusCode() != 304) {
            content = BinaryUtils.toByteArray(httpResponse.getContent());
            response = this.getUnmarshaller().unmarshall(new String(content), contentType);
            if (null == response) {
                throw new JdcloudSdkException("Illegal Content");
            }
        }
        response.setRequestId(reqId);
        response.setJdcloudHttpResponse(this.copyHttpResponse(httpResponse, content));
        return response;
    }

    private ContentType getContentType(String contentTypeString) {
        ContentType contentType = ContentType.APPLICATION_JSON;
        if (StringUtils.isNotBlank(contentTypeString)) {
            String contentTypeLowerCase = contentTypeString.toLowerCase();
            if (contentTypeLowerCase.startsWith(ContentType.TEXT_XML.toString())) {
                contentType = ContentType.TEXT_XML;
            } else if (contentTypeLowerCase.startsWith(ContentType.APPLICATION_XML.toString())) {
                contentType = ContentType.APPLICATION_XML;
            }
        }
        return contentType;
    }

    private JdcloudHttpResponse copyHttpResponse(HttpResponse httpResponse, byte[] content) {
        JdcloudHttpResponse jdcloudHttpResponse = new JdcloudHttpResponse();
        jdcloudHttpResponse.setContent(content);
        jdcloudHttpResponse.setContentCharset(httpResponse.getContentCharset());
        jdcloudHttpResponse.setContentEncoding(httpResponse.getContentEncoding());
        jdcloudHttpResponse.setContentType(httpResponse.getContentType());
        jdcloudHttpResponse.setHeaders(httpResponse.getHeaders());
        jdcloudHttpResponse.setMediaType(httpResponse.getMediaType());
        jdcloudHttpResponse.setContentLoggingLimit(httpResponse.getContentLoggingLimit());
        jdcloudHttpResponse.setStatusCode(httpResponse.getStatusCode());
        jdcloudHttpResponse.setStatusMessage(httpResponse.getStatusMessage());
        return jdcloudHttpResponse;
    }

    private String getRequestValue(String fieldName, JdcloudRequest request) {
        Field field = null;
        try {
            field = request.getClass().getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            logger.info(fieldName, (Object)" not fount");
        }
        try {
            if (field == null) {
                field = request.getClass().getSuperclass().getDeclaredField(fieldName);
            }
            field.setAccessible(true);
            Object value = field.get(request);
            if (value == null) {
                throw new JdcloudSdkException("field " + fieldName + " not set.");
            }
            return String.valueOf(value);
        }
        catch (Exception e) {
            throw new JdcloudSdkException("can not get value of request field '" + fieldName + "'.", e);
        }
    }

    private String getRequestValue(String fieldName, JsonElement jsonElement) {
        try {
            JsonElement value = jsonElement.getAsJsonObject().get(fieldName);
            if (value == null) {
                throw new JdcloudSdkException("field " + fieldName + " not set.");
            }
            return value.getAsString();
        }
        catch (Exception e) {
            throw new JdcloudSdkException("can not get value of request field '" + fieldName + "'.", e);
        }
    }

    private String getParams(JdcloudRequest request) throws UnsupportedEncodingException {
        if (request == null) {
            return "";
        }
        if (SdkHttpMethod.DELETE.name().equalsIgnoreCase(this.method()) || SdkHttpMethod.PUT.name().equalsIgnoreCase(this.method()) || SdkHttpMethod.GET.name().equalsIgnoreCase(this.method()) || SdkHttpMethod.PATCH.name().equalsIgnoreCase(this.method()) || SdkHttpMethod.HEAD.name().equalsIgnoreCase(this.method()) || SdkHttpMethod.POST.name().equalsIgnoreCase(this.method())) {
            Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().setDateFormat(dateFormat).create();
            JsonElement jsonElement = gson.toJsonTree((Object)request);
            String params = this.createParam(jsonElement, "", request);
            if (StringUtils.isNotBlank(params)) {
                return "?" + params.substring(1);
            }
            return "";
        }
        return "";
    }

    String createParam(JsonElement jsonElement, String superName, Object request) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        if (jsonElement instanceof JsonObject) {
            this.objectParam(jsonElement, superName, sb, request);
        } else if (jsonElement instanceof JsonArray) {
            this.arrayParam(jsonElement, superName, sb);
        }
        return sb.toString();
    }

    String createParam(JsonElement jsonElement, String superName) throws UnsupportedEncodingException {
        return this.createParam(jsonElement, superName, null);
    }

    private void arrayParam(JsonElement jsonElement, String superName, StringBuilder sb) throws UnsupportedEncodingException {
        Iterator iterator = ((JsonArray)jsonElement).iterator();
        int i = 1;
        while (iterator.hasNext()) {
            JsonElement value = (JsonElement)iterator.next();
            if (value instanceof JsonArray) {
                sb.append(this.createParam(value, superName + "." + i++));
                continue;
            }
            if (value instanceof JsonObject) {
                sb.append(this.createParam(value, superName + "." + i++));
                continue;
            }
            sb.append("&");
            sb.append(superName);
            sb.append(".");
            sb.append(i++);
            sb.append("=");
            sb.append(URLEncoder.encode(value.toString().replaceAll("^\"|\"$", ""), charset));
        }
    }

    private void objectParam(JsonElement jsonElement, String superName, StringBuilder sb, Object request) throws UnsupportedEncodingException {
        List<String> queryParmList = this.getParamList(request, QueryParameter.class);
        for (Map.Entry e : ((JsonObject)jsonElement).entrySet()) {
            String name = (String)e.getKey();
            if (!queryParmList.contains(name)) continue;
            JsonElement value = (JsonElement)e.getValue();
            String pname = this.createParamKey(superName, name);
            if (value instanceof JsonArray) {
                sb.append(this.createParam(value, pname));
                continue;
            }
            if (value instanceof JsonObject) {
                sb.append(this.createParam(value, pname));
                continue;
            }
            if (value == null) continue;
            sb.append("&");
            sb.append(pname);
            sb.append("=");
            sb.append(URLEncoder.encode(value.toString().replaceAll("^\"|\"$", ""), charset));
        }
    }

    private List<String> getParamList(Object request, Class<? extends Annotation> annotationClass) {
        ArrayList<String> paramList = new ArrayList<String>();
        if (request == null) {
            return paramList;
        }
        Field[] array = request.getClass().getDeclaredFields();
        try {
            for (Field field : array) {
                if (!field.isAnnotationPresent(annotationClass)) continue;
                field.setAccessible(true);
                String value = field.getAnnotation(SerializedName.class).value();
                if (value == null || !StringUtils.isNotBlank(value.toString())) continue;
                paramList.add(value.toString());
            }
        }
        catch (IllegalArgumentException e) {
            throw new JdcloudSdkException(e);
        }
        return paramList;
    }

    private String createParamKey(String superName, String name) {
        if (StringUtils.isBlank(superName)) {
            return name;
        }
        return superName + "." + name;
    }

    private void setCustomHeader(HttpHeaders headers) {
        Map<String, String> customHeaders = this.jdcloudClient.getCustomHeader();
        for (Map.Entry<String, String> entry : customHeaders.entrySet()) {
            String key = entry.getKey();
            if (null == key) continue;
            String value = entry.getValue();
            if (base64Headers.contains(key)) {
                try {
                    value = Base64Utils.encodeAsString(value.getBytes("UTF-8"));
                }
                catch (Exception e) {
                    throw new JdcloudSdkException(e);
                }
            }
            headers.put(key, (Object)value);
        }
    }
}

