/*
 * Decompiled with CFR 0.152.
 */
package com.jdcloud.sdk.http;

import com.jdcloud.sdk.http.ContentType;
import com.jdcloud.sdk.http.Protocol;

public interface HttpRequestConfig {
    public int getConnectionTimeout();

    public int getSocketTimeout();

    public Protocol getProtocol();

    public ContentType getContentType();

    public static class Builder {
        private DefaultHttpRequestConfig config = new DefaultHttpRequestConfig();

        public Builder connectionTimeout(int timeout) {
            this.config.connectionTimeout = timeout;
            return this;
        }

        public Builder socketTimeout(int timeout) {
            this.config.socketTimeout = timeout;
            return this;
        }

        public Builder protocol(Protocol protocol) {
            this.config.protocol = protocol;
            return this;
        }

        public Builder contentType(ContentType contentType) {
            this.config.contentType = contentType;
            return this;
        }

        public HttpRequestConfig build() {
            return this.config;
        }

        private static class DefaultHttpRequestConfig
        implements HttpRequestConfig {
            private int connectionTimeout = -1;
            private int socketTimeout = -1;
            private Protocol protocol = Protocol.HTTPS;
            private ContentType contentType = ContentType.APPLICATION_JSON;

            private DefaultHttpRequestConfig() {
            }

            @Override
            public int getConnectionTimeout() {
                return this.connectionTimeout;
            }

            @Override
            public int getSocketTimeout() {
                return this.socketTimeout;
            }

            @Override
            public Protocol getProtocol() {
                return this.protocol;
            }

            @Override
            public ContentType getContentType() {
                return this.contentType;
            }
        }
    }
}

