/*
 * Decompiled with CFR 0.152.
 */
package com.jdcloud.sdk.utils;

import com.google.api.client.util.Sets;
import com.jdcloud.sdk.JdcloudSdkException;
import com.jdcloud.sdk.annotation.Required;
import java.lang.reflect.Field;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterUtils {
    private static Logger logger = LoggerFactory.getLogger(ParameterUtils.class);
    private static Set<String> javaType = Sets.newHashSet();

    public static void checkRequest(Object request) {
        Field[] array = request.getClass().getDeclaredFields();
        if (array != null) {
            try {
                for (Field field : array) {
                    if (!field.isAnnotationPresent(Required.class)) continue;
                    field.setAccessible(true);
                    Object value = field.get(request);
                    if (value == null) {
                        logger.info("The argument \u2018{}\u2019 is required", (Object)field.getName());
                        throw new JdcloudSdkException("The argument \u2018" + field.getName() + "\u2019 is required");
                    }
                    if (javaType.contains(field.getType().getName())) continue;
                    ParameterUtils.checkRequest(value);
                }
            }
            catch (IllegalArgumentException e) {
                logger.error("IllegalArgumentException");
                throw new JdcloudSdkException(e);
            }
            catch (IllegalAccessException e) {
                logger.error("IllegalAccessException");
                throw new JdcloudSdkException(e);
            }
        }
    }

    static {
        javaType.add("java.lang.String");
        javaType.add("java.lang.Byte");
        javaType.add("java.lang.Boolean");
        javaType.add("java.lang.Character");
        javaType.add("java.lang.Double");
        javaType.add("java.lang.Enum");
        javaType.add("java.lang.Float");
        javaType.add("java.lang.Integer");
        javaType.add("java.lang.Long");
        javaType.add("java.lang.Short");
        javaType.add("java.util.Date");
        javaType.add("java.util.List");
        javaType.add("java.util.Map");
    }
}

