/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.captcha;

import com.jfinal.captcha.Captcha;
import com.jfinal.captcha.ICaptchaCache;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;

public class CaptchaCache
implements ICaptchaCache {
    private ConcurrentHashMap<String, Captcha> map = new ConcurrentHashMap();
    private int interval = 90000;
    private Timer timer;

    public CaptchaCache() {
        this.autoRemoveExpiredCaptcha();
    }

    private void autoRemoveExpiredCaptcha() {
        this.timer = new Timer("CaptchaCache", true);
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                for (Map.Entry e : CaptchaCache.this.map.entrySet()) {
                    if (!((Captcha)e.getValue()).isExpired()) continue;
                    CaptchaCache.this.map.remove(e.getKey());
                }
            }
        }, this.interval, (long)this.interval);
    }

    @Override
    public void put(Captcha captcha) {
        this.map.put(captcha.getKey(), captcha);
    }

    @Override
    public Captcha get(String key) {
        return key != null ? this.map.get(key) : null;
    }

    @Override
    public void remove(String key) {
        this.map.remove(key);
    }

    @Override
    public void removeAll() {
        this.map.clear();
    }

    public boolean contains(String key) {
        return this.map.containsKey(key);
    }
}

