/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.core;

import com.jfinal.config.Constants;
import com.jfinal.config.JFinalConfig;
import com.jfinal.core.Action;
import com.jfinal.core.ActionHandler;
import com.jfinal.core.ActionMapping;
import com.jfinal.core.Config;
import com.jfinal.handler.Handler;
import com.jfinal.handler.HandlerFactory;
import com.jfinal.kit.LogKit;
import com.jfinal.kit.PathKit;
import com.jfinal.plugin.IPlugin;
import com.jfinal.render.RenderManager;
import com.jfinal.server.IServer;
import com.jfinal.server.jetty.ServerFactory;
import com.jfinal.token.ITokenCache;
import com.jfinal.token.TokenManager;
import com.jfinal.upload.OreillyCos;
import java.util.List;
import javax.servlet.ServletContext;

public final class JFinal {
    private Constants constants;
    private ActionMapping actionMapping;
    private Handler handler;
    private ServletContext servletContext;
    private String contextPath = "";
    private static IServer server;
    private static final JFinal me;

    private JFinal() {
    }

    public static JFinal me() {
        return me;
    }

    void init(JFinalConfig jfinalConfig, ServletContext servletContext) {
        this.servletContext = servletContext;
        this.contextPath = servletContext.getContextPath();
        this.initPathKit();
        Config.configJFinal(jfinalConfig);
        this.constants = Config.getConstants();
        this.initActionMapping();
        this.initHandler();
        this.initRender();
        this.initOreillyCos();
        this.initTokenManager();
    }

    private void initTokenManager() {
        ITokenCache tokenCache = this.constants.getTokenCache();
        if (tokenCache != null) {
            TokenManager.init(tokenCache);
        }
    }

    private void initHandler() {
        ActionHandler actionHandler = Config.getHandlers().getActionHandler();
        if (actionHandler == null) {
            actionHandler = new ActionHandler();
        }
        actionHandler.init(this.actionMapping, this.constants);
        this.handler = HandlerFactory.getHandler(Config.getHandlers().getHandlerList(), actionHandler);
    }

    private void initOreillyCos() {
        OreillyCos.init(this.constants.getBaseUploadPath(), this.constants.getMaxPostSize(), this.constants.getEncoding());
    }

    private void initPathKit() {
        String path = this.servletContext.getRealPath("/");
        PathKit.setWebRootPath(path);
    }

    private void initRender() {
        RenderManager.me().init(Config.getEngine(), this.constants, this.servletContext);
    }

    private void initActionMapping() {
        this.actionMapping = new ActionMapping(Config.getRoutes());
        this.actionMapping.buildActionMapping();
        Config.getRoutes().clear();
    }

    void stopPlugins() {
        List<IPlugin> plugins = Config.getPlugins().getPluginList();
        if (plugins != null) {
            for (int i = plugins.size() - 1; i >= 0; --i) {
                boolean success = false;
                try {
                    success = plugins.get(i).stop();
                }
                catch (Exception e) {
                    success = false;
                    LogKit.error(e.getMessage(), e);
                }
                if (success) continue;
                System.err.println("Plugin stop error: " + plugins.get(i).getClass().getName());
            }
        }
    }

    Handler getHandler() {
        return this.handler;
    }

    public Constants getConstants() {
        return Config.getConstants();
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public Action getAction(String url, String[] urlPara) {
        return this.actionMapping.getAction(url, urlPara);
    }

    public List<String> getAllActionKeys() {
        return this.actionMapping.getAllActionKeys();
    }

    public static void start() {
        server = ServerFactory.getServer();
        server.start();
    }

    public static void start(String webAppDir, int port, String context, int scanIntervalSeconds) {
        server = ServerFactory.getServer((String)webAppDir, (int)port, (String)context, (int)scanIntervalSeconds);
        server.start();
    }

    @Deprecated
    public static void start(String webAppDir, int port, String context) {
        JFinal.start(webAppDir, port, context, 0);
    }

    public static void stop() {
        server.stop();
    }

    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            server = ServerFactory.getServer();
            server.start();
            return;
        }
        if (args.length == 4) {
            String webAppDir = args[0];
            int port = Integer.parseInt(args[1]);
            String context = args[2];
            int scanIntervalSeconds = Integer.parseInt(args[3]);
            server = ServerFactory.getServer((String)webAppDir, (int)port, (String)context, (int)scanIntervalSeconds);
            server.start();
            return;
        }
        if (args.length == 3) {
            JFinal.start(args[0], Integer.parseInt(args[1]), args[2]);
            return;
        }
        throw new RuntimeException("Boot parameter error. The right parameter like this: src/main/webapp 80 / 5");
    }

    static {
        me = new JFinal();
    }
}

