/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.core;

import com.jfinal.config.Constants;
import com.jfinal.config.JFinalConfig;
import com.jfinal.core.Config;
import com.jfinal.core.JFinal;
import com.jfinal.handler.Handler;
import com.jfinal.log.Log;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JFinalFilter
implements Filter {
    private Handler handler;
    private String encoding;
    private JFinalConfig jfinalConfig;
    private Constants constants;
    private static final JFinal jfinal = JFinal.me();
    private static Log log;
    private int contextPathLength;

    public JFinalFilter() {
        this.jfinalConfig = null;
    }

    public JFinalFilter(JFinalConfig jfinalConfig) {
        this.jfinalConfig = jfinalConfig;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        if (this.jfinalConfig == null) {
            this.createJFinalConfig(filterConfig.getInitParameter("configClass"));
        }
        jfinal.init(this.jfinalConfig, filterConfig.getServletContext());
        String contextPath = filterConfig.getServletContext().getContextPath();
        this.contextPathLength = contextPath == null || "/".equals(contextPath) ? 0 : contextPath.length();
        this.constants = Config.getConstants();
        this.encoding = this.constants.getEncoding();
        this.jfinalConfig.onStart();
        this.jfinalConfig.afterJFinalStart();
        this.handler = jfinal.getHandler();
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        boolean[] isHandled;
        String target;
        HttpServletResponse response;
        HttpServletRequest request;
        block5: {
            request = (HttpServletRequest)req;
            response = (HttpServletResponse)res;
            request.setCharacterEncoding(this.encoding);
            target = request.getRequestURI();
            if (this.contextPathLength != 0) {
                target = target.substring(this.contextPathLength);
            }
            isHandled = new boolean[]{false};
            try {
                this.handler.handle(target, request, response, isHandled);
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block5;
                String qs = request.getQueryString();
                log.error(qs == null ? target : target + "?" + qs, e);
            }
        }
        if (!isHandled[0]) {
            if (this.constants.getDenyAccessJsp() && this.isJsp(target)) {
                return;
            }
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    public void destroy() {
        this.handler = null;
        this.jfinalConfig.onStop();
        this.jfinalConfig.beforeJFinalStop();
        jfinal.stopPlugins();
    }

    protected void createJFinalConfig(String configClass) {
        if (configClass == null) {
            throw new RuntimeException("The configClass parameter of JFinalFilter can not be blank");
        }
        try {
            Object temp = Class.forName(configClass).newInstance();
            this.jfinalConfig = (JFinalConfig)temp;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Can not create instance of class: " + configClass, e);
        }
    }

    static void initLog() {
        log = Log.getLog(JFinalFilter.class);
    }

    boolean isJsp(String t) {
        char c;
        int end = t.length() - 1;
        if (end > 3 && ((c = t.charAt(end)) == 'x' || c == 'X')) {
            --end;
        }
        return !(end <= 2 || (c = t.charAt(end)) != 'p' && c != 'P' || --end <= 1 || (c = t.charAt(end)) != 's' && c != 'S' || --end <= 0 || (c = t.charAt(end)) != 'j' && c != 'J' || --end <= -1 || (c = t.charAt(end)) != '.');
    }
}

