/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.core.paragetter;

import com.jfinal.core.Action;
import com.jfinal.core.ActionException;
import com.jfinal.core.Controller;
import com.jfinal.core.paragetter.ParaGetter;
import com.jfinal.kit.StrKit;
import com.jfinal.render.RenderManager;

public class DoubleGetter
extends ParaGetter<Double> {
    public DoubleGetter(String parameterName, String defaultValue) {
        super(parameterName, defaultValue);
    }

    @Override
    public Double get(Action action, Controller c) {
        String value = c.getPara(this.getParameterName());
        try {
            if (StrKit.isBlank(value)) {
                return (Double)this.getDefaultValue();
            }
            value = value.trim();
            return this.to(value);
        }
        catch (Exception e) {
            throw new ActionException(400, RenderManager.me().getRenderFactory().getErrorRender(400), "Can not parse the parameter \"" + value + "\" to Double value.");
        }
    }

    @Override
    protected Double to(String v) {
        if (StrKit.notBlank(v)) {
            return Double.parseDouble(v);
        }
        return null;
    }
}

