/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.core.paragetter;

import com.jfinal.core.Action;
import com.jfinal.core.Controller;
import com.jfinal.core.paragetter.ParaGetter;
import com.jfinal.kit.StrKit;

public class EnumGetter<T extends Enum>
extends ParaGetter<T> {
    private final Class<T> enumType;

    public EnumGetter(Class<T> enumType, String parameterName, String defaultValue) {
        super(parameterName, defaultValue);
        this.enumType = enumType;
    }

    @Override
    public T get(Action action, Controller c) {
        String value = c.getPara(this.getParameterName());
        if (StrKit.notBlank(value)) {
            return (T)this.to(value);
        }
        return (T)((Enum)this.getDefaultValue());
    }

    @Override
    protected T to(String v) {
        if (StrKit.notBlank(v)) {
            try {
                return Enum.valueOf(this.enumType, v.trim());
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }
}

