/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.core.paragetter;

import com.jfinal.core.Action;
import com.jfinal.core.ActionException;
import com.jfinal.core.Controller;
import com.jfinal.core.converter.Converters;
import com.jfinal.core.paragetter.ParaGetter;
import com.jfinal.kit.StrKit;
import com.jfinal.render.RenderManager;
import java.sql.Date;
import java.text.ParseException;

public class SqlDateGetter
extends ParaGetter<Date> {
    private static Converters.SqlDateConverter converter = new Converters.SqlDateConverter();

    public SqlDateGetter(String parameterName, String defaultValue) {
        super(parameterName, defaultValue);
    }

    @Override
    public Date get(Action action, Controller c) {
        String value = c.getPara(this.getParameterName());
        if (StrKit.notBlank(value)) {
            return this.to(value);
        }
        return (Date)this.getDefaultValue();
    }

    @Override
    protected Date to(String v) {
        if (StrKit.isBlank(v)) {
            return null;
        }
        try {
            return converter.convert(v);
        }
        catch (ParseException e) {
            throw new ActionException(400, RenderManager.me().getRenderFactory().getErrorRender(400), "Can not parse the parameter \"" + v + "\" to java.sql.Date");
        }
    }
}

