/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.proxy;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.InterceptorManager;
import com.jfinal.aop.Invocation;
import com.jfinal.ext.proxy.CglibProxyFactory;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;

class CglibCallback
implements MethodInterceptor {
    private static final Set<String> excludedMethodName = CglibCallback.buildExcludedMethodName();
    private static final InterceptorManager interMan = InterceptorManager.me();

    CglibCallback() {
    }

    public Object intercept(Object target, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
        CglibProxyFactory.MethodKey key;
        Interceptor[] inters;
        if (excludedMethodName.contains(method.getName())) {
            return methodProxy.invokeSuper(target, args);
        }
        Class<?> targetClass = target.getClass();
        if (targetClass.getName().indexOf("$$EnhancerBy") != -1) {
            targetClass = targetClass.getSuperclass();
        }
        if ((inters = CglibProxyFactory.IntersCache.get(key = CglibProxyFactory.IntersCache.getMethodKey(targetClass, method))) == null) {
            inters = interMan.buildServiceMethodInterceptor(targetClass, method);
            CglibProxyFactory.IntersCache.put(key, inters);
        }
        Invocation invocation = new Invocation(target, method, inters, x -> methodProxy.invokeSuper(target, x), args);
        invocation.invoke();
        return invocation.getReturnValue();
    }

    private static final Set<String> buildExcludedMethodName() {
        Method[] methods;
        HashSet<String> excludedMethodName = new HashSet<String>(64, 0.25f);
        for (Method m : methods = Object.class.getDeclaredMethods()) {
            excludedMethodName.add(m.getName());
        }
        return excludedMethodName;
    }
}

