/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.plugin.activerecord;

import com.jfinal.plugin.activerecord.Model;
import com.jfinal.plugin.activerecord.Page;
import com.jfinal.plugin.activerecord.PageSqlKit;
import com.jfinal.plugin.activerecord.SqlPara;
import java.util.List;
import java.util.Map;

public class DaoTemplate<M extends Model> {
    protected Model<M> dao;
    protected SqlPara sqlPara;

    public DaoTemplate(Model dao, String key, Map<?, ?> data) {
        this.dao = dao;
        this.sqlPara = dao.getSqlPara(key, data);
    }

    public DaoTemplate(Model dao, String key, Object ... paras) {
        this.dao = dao;
        this.sqlPara = dao.getSqlPara(key, paras);
    }

    public DaoTemplate(boolean byString, Model dao, String content, Map<?, ?> data) {
        this.dao = dao;
        this.sqlPara = dao.getSqlParaByString(content, data);
    }

    public DaoTemplate(boolean byString, Model dao, String content, Object ... paras) {
        this.dao = dao;
        this.sqlPara = dao.getSqlParaByString(content, paras);
    }

    public List<M> find() {
        return this.dao.find(this.sqlPara);
    }

    public M findFirst() {
        return this.dao.findFirst(this.sqlPara);
    }

    public Page<M> paginate(int pageNumber, int pageSize) {
        return this.dao.paginate(pageNumber, pageSize, this.sqlPara);
    }

    public Page<M> paginate(int pageNumber, int pageSize, boolean isGroupBySql) {
        return this.dao.paginate(pageNumber, pageSize, isGroupBySql, this.sqlPara);
    }

    public List<M> findByCache(String cacheName, Object key) {
        return this.dao.findByCache(cacheName, key, this.sqlPara.getSql(), this.sqlPara.getPara());
    }

    public M findFirstByCache(String cacheName, Object key) {
        return this.dao.findFirstByCache(cacheName, key, this.sqlPara.getSql(), this.sqlPara.getPara());
    }

    public Page<M> paginateByCache(String cacheName, Object key, int pageNumber, int pageSize) {
        String[] sqls = PageSqlKit.parsePageSql(this.sqlPara.getSql());
        return this.dao.paginateByCache(cacheName, key, pageNumber, pageSize, sqls[0], sqls[1], this.sqlPara.getPara());
    }

    public Page<M> paginateByCache(String cacheName, Object key, int pageNumber, int pageSize, boolean isGroupBySql) {
        String[] sqls = PageSqlKit.parsePageSql(this.sqlPara.getSql());
        return this.dao.paginateByCache(cacheName, key, pageNumber, pageSize, isGroupBySql, sqls[0], sqls[1], this.sqlPara.getPara());
    }
}

