/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.render;

import com.jfinal.core.JFinal;
import com.jfinal.render.Render;
import com.jfinal.render.RenderException;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.ServletContext;

public class FreeMarkerRender
extends Render {
    private static final String contentType = "text/html; charset=" + FreeMarkerRender.getEncoding();
    private static final Configuration config = new Configuration();

    public FreeMarkerRender(String view) {
        this.view = view;
    }

    public static Configuration getConfiguration() {
        return config;
    }

    public static void setProperty(String propertyName, String propertyValue) {
        try {
            FreeMarkerRender.getConfiguration().setSetting(propertyName, propertyValue);
        }
        catch (TemplateException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setSharedVariable(String name, Object object) {
        try {
            FreeMarkerRender.getConfiguration().setSharedVariable(name, object);
        }
        catch (TemplateException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setProperties(Properties properties) {
        try {
            FreeMarkerRender.getConfiguration().setSettings(properties);
        }
        catch (TemplateException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setTemplateLoadingPath(String path) {
        config.setServletContextForTemplateLoading((Object)JFinal.me().getServletContext(), path);
    }

    static void init(ServletContext servletContext, Locale locale, int template_update_delay) {
        config.setServletContextForTemplateLoading((Object)servletContext, "/");
        if (FreeMarkerRender.getDevMode()) {
            config.setTemplateUpdateDelay(0);
        } else {
            config.setTemplateUpdateDelay(template_update_delay);
        }
        config.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        config.setObjectWrapper(ObjectWrapper.BEANS_WRAPPER);
        config.setDefaultEncoding(FreeMarkerRender.getEncoding());
        config.setOutputEncoding(FreeMarkerRender.getEncoding());
        config.setLocale(locale);
        config.setLocalizedLookup(false);
        config.setNumberFormat("#0.#####");
        config.setDateFormat("yyyy-MM-dd");
        config.setTimeFormat("HH:mm:ss");
        config.setDateTimeFormat("yyyy-MM-dd HH:mm:ss");
    }

    public String getContentType() {
        return contentType;
    }

    @Override
    public void render() {
        this.response.setContentType(this.getContentType());
        HashMap<String, Object> data = new HashMap<String, Object>();
        Enumeration attrs = this.request.getAttributeNames();
        while (attrs.hasMoreElements()) {
            String attrName = (String)attrs.nextElement();
            data.put(attrName, this.request.getAttribute(attrName));
        }
        PrintWriter writer = null;
        try {
            Template template = config.getTemplate(this.view);
            writer = this.response.getWriter();
            template.process(data, (Writer)writer);
        }
        catch (Exception e) {
            throw new RenderException(e);
        }
    }
}

