/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.render;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.jfinal.kit.StrKit;
import com.jfinal.render.Render;
import com.jfinal.render.RenderException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;

public class QrCodeRender
extends Render {
    protected String content;
    protected int width;
    protected int height;
    protected ErrorCorrectionLevel errorCorrectionLevel;

    public QrCodeRender(String content, int width, int height) {
        this.init(content, width, height, null);
    }

    public QrCodeRender(String content, int width, int height, ErrorCorrectionLevel errorCorrectionLevel) {
        this.init(content, width, height, errorCorrectionLevel);
    }

    public QrCodeRender(String content, int width, int height, char errorCorrectionLevel) {
        this.init(content, width, height, errorCorrectionLevel);
    }

    protected void init(String content, int width, int height, char errorCorrectionLevel) {
        if (errorCorrectionLevel == 'H') {
            this.init(content, width, height, ErrorCorrectionLevel.H);
        } else if (errorCorrectionLevel == 'Q') {
            this.init(content, width, height, ErrorCorrectionLevel.Q);
        } else if (errorCorrectionLevel == 'M') {
            this.init(content, width, height, ErrorCorrectionLevel.M);
        } else if (errorCorrectionLevel == 'L') {
            this.init(content, width, height, ErrorCorrectionLevel.L);
        } else {
            throw new IllegalArgumentException("errorCorrectionLevel \u7ea0\u9519\u7ea7\u522b\u53c2\u6570\u503c\uff0c\u4ece\u9ad8\u5230\u4f4e\u5fc5\u987b\u4e3a\uff1a 'H'\u3001'Q'\u3001'M'\u3001'L'");
        }
    }

    protected void init(String content, int width, int height, ErrorCorrectionLevel errorCorrectionLevel) {
        if (StrKit.isBlank(content)) {
            throw new IllegalArgumentException("content \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException("width \u4e0e height \u4e0d\u80fd\u5c0f\u4e8e 0");
        }
        this.content = content;
        this.width = width;
        this.height = height;
        this.errorCorrectionLevel = errorCorrectionLevel;
    }

    @Override
    public void render() {
        this.response.setHeader("Pragma", "no-cache");
        this.response.setHeader("Cache-Control", "no-cache");
        this.response.setDateHeader("Expires", 0L);
        this.response.setContentType("image/png");
        HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
        hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
        hints.put(EncodeHintType.MARGIN, 0);
        if (this.errorCorrectionLevel != null) {
            hints.put(EncodeHintType.ERROR_CORRECTION, this.errorCorrectionLevel);
        }
        try {
            QRCodeWriter writer = new QRCodeWriter();
            BitMatrix bitMatrix = writer.encode(this.content, BarcodeFormat.QR_CODE, this.width, this.height, hints);
            MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)"png", (OutputStream)this.response.getOutputStream());
        }
        catch (IOException e) {
            String name = e.getClass().getSimpleName();
            if (!"ClientAbortException".equals(name) && !"EofException".equals(name)) {
                throw new RenderException(e);
            }
        }
        catch (Exception e) {
            throw new RenderException(e);
        }
    }
}

