/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.render;

import com.jfinal.config.Constants;
import com.jfinal.kit.LogKit;
import com.jfinal.kit.PathKit;
import com.jfinal.plugin.activerecord.ModelRecordElResolver;
import com.jfinal.render.FileRender;
import com.jfinal.render.FreeMarkerRender;
import com.jfinal.render.IRenderFactory;
import com.jfinal.render.Render;
import com.jfinal.render.RenderFactory;
import com.jfinal.render.TemplateRender;
import com.jfinal.render.VelocityRender;
import com.jfinal.template.Engine;
import java.io.File;
import java.util.Locale;
import javax.servlet.ServletContext;

public class RenderManager {
    private Engine engine;
    private Constants constants;
    private ServletContext servletContext;
    private IRenderFactory renderFactory = null;
    private static final RenderManager me = new RenderManager();

    private RenderManager() {
    }

    public static RenderManager me() {
        return me;
    }

    public IRenderFactory getRenderFactory() {
        return this.renderFactory;
    }

    public void setRenderFactory(IRenderFactory renderFactory) {
        if (renderFactory == null) {
            throw new IllegalArgumentException("renderFactory can not be null");
        }
        this.renderFactory = renderFactory;
    }

    public void init(Engine engine, Constants constants, ServletContext servletContext) {
        this.engine = engine;
        this.constants = constants;
        this.servletContext = servletContext;
        Render.init(constants.getEncoding(), constants.getDevMode());
        this.initTemplateRender();
        this.initFreeMarkerRender(servletContext);
        this.initVelocityRender(servletContext);
        this.initJspRender(servletContext);
        this.initFileRender(servletContext);
        if (this.renderFactory == null) {
            this.renderFactory = new RenderFactory();
        }
        this.renderFactory.init(engine, constants, servletContext);
    }

    private void initTemplateRender() {
        TemplateRender.init(this.engine);
    }

    private void initFreeMarkerRender(ServletContext servletContext) {
        try {
            Class.forName("freemarker.template.Template");
            FreeMarkerRender.init(servletContext, Locale.getDefault(), this.constants.getFreeMarkerTemplateUpdateDelay());
        }
        catch (ClassNotFoundException e) {
            LogKit.logNothing(e);
        }
    }

    private void initVelocityRender(ServletContext servletContext) {
        try {
            Class.forName("org.apache.velocity.VelocityContext");
            VelocityRender.init(servletContext);
        }
        catch (ClassNotFoundException e) {
            LogKit.logNothing(e);
        }
    }

    private void initJspRender(ServletContext servletContext) {
        try {
            Class.forName("javax.el.ELResolver");
            Class.forName("javax.servlet.jsp.JspFactory");
            ModelRecordElResolver.init(servletContext);
        }
        catch (ClassNotFoundException e) {
            LogKit.logNothing(e);
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (Exception e) {
            LogKit.logNothing(e);
        }
    }

    private void initFileRender(ServletContext servletContext) {
        String downloadPath = this.constants.getBaseDownloadPath();
        downloadPath = downloadPath.trim();
        String baseDownloadPath = PathKit.isAbsolutePath(downloadPath = downloadPath.replaceAll("\\\\", "/")) ? downloadPath : PathKit.getWebRootPath() + File.separator + downloadPath;
        if (!baseDownloadPath.equals("/") && baseDownloadPath.endsWith("/")) {
            baseDownloadPath = baseDownloadPath.substring(0, baseDownloadPath.length() - 1);
        }
        FileRender.init(baseDownloadPath, servletContext);
    }

    public Engine getEngine() {
        return this.engine;
    }

    public Constants getConstants() {
        return this.constants;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }
}

