/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.config;

import com.jfinal.aop.AopManager;
import com.jfinal.captcha.CaptchaManager;
import com.jfinal.captcha.ICaptchaCache;
import com.jfinal.config.Routes;
import com.jfinal.core.ActionMapping;
import com.jfinal.core.ActionReporter;
import com.jfinal.core.Const;
import com.jfinal.core.ControllerFactory;
import com.jfinal.core.paragetter.JsonRequest;
import com.jfinal.core.paragetter.ParaProcessor;
import com.jfinal.ext.proxy.CglibProxyFactory;
import com.jfinal.i18n.I18n;
import com.jfinal.json.IJsonFactory;
import com.jfinal.json.JsonManager;
import com.jfinal.kit.StrKit;
import com.jfinal.log.ILogFactory;
import com.jfinal.log.LogManager;
import com.jfinal.proxy.ProxyFactory;
import com.jfinal.proxy.ProxyManager;
import com.jfinal.render.ErrorRender;
import com.jfinal.render.IRenderFactory;
import com.jfinal.render.RenderManager;
import com.jfinal.render.ViewType;
import com.jfinal.token.ITokenCache;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;

public final class Constants {
    private boolean devMode = false;
    private String baseUploadPath = "upload";
    private String baseDownloadPath = "download";
    private String encoding = "UTF-8";
    private String urlParaSeparator = "-";
    private ViewType viewType = Const.DEFAULT_VIEW_TYPE;
    private String viewExtension = ".html";
    private long maxPostSize = 0xA00000L;
    private int freeMarkerTemplateUpdateDelay = 3600;
    private ControllerFactory controllerFactory = Const.DEFAULT_CONTROLLER_FACTORY;
    private ActionReporter actionReporter = Const.DEFAULT_ACTION_REPORTER;
    private int configPluginOrder = 3;
    private boolean denyAccessJsp = true;
    private ITokenCache tokenCache = null;
    private Function<Routes, ActionMapping> actionMappingFunc = null;

    public void setDevMode(boolean devMode) {
        this.devMode = devMode;
    }

    public boolean getDevMode() {
        return this.devMode;
    }

    public void setConfigPluginOrder(int configPluginOrder) {
        if (configPluginOrder < 1 || configPluginOrder > 5) {
            throw new IllegalArgumentException("configPluginOrder \u53ea\u80fd\u53d6\u503c\u4e3a\uff1a1\u30012\u30013\u30014\u30015");
        }
        this.configPluginOrder = configPluginOrder;
    }

    public int getConfigPluginOrder() {
        return this.configPluginOrder;
    }

    public void setRenderFactory(IRenderFactory renderFactory) {
        if (renderFactory == null) {
            throw new IllegalArgumentException("renderFactory can not be null.");
        }
        RenderManager.me().setRenderFactory(renderFactory);
    }

    public void setJsonFactory(IJsonFactory jsonFactory) {
        if (jsonFactory == null) {
            throw new IllegalArgumentException("jsonFactory can not be null.");
        }
        JsonManager.me().setDefaultJsonFactory(jsonFactory);
    }

    public void setJsonDatePattern(String datePattern) {
        if (StrKit.isBlank(datePattern)) {
            throw new IllegalArgumentException("datePattern can not be blank.");
        }
        JsonManager.me().setDefaultDatePattern(datePattern);
    }

    public void setCaptchaCache(ICaptchaCache captchaCache) {
        CaptchaManager.me().setCaptchaCache(captchaCache);
    }

    public void setLogFactory(ILogFactory logFactory) {
        if (logFactory == null) {
            throw new IllegalArgumentException("logFactory can not be null.");
        }
        LogManager.me().setDefaultLogFactory(logFactory);
    }

    public void setToSlf4jLogFactory() {
        LogManager.me().setToSlf4jLogFactory();
    }

    public void setProxyFactory(ProxyFactory proxyFactory) {
        ProxyManager.me().setProxyFactory(proxyFactory);
    }

    public void setToCglibProxyFactory() {
        this.setProxyFactory(new CglibProxyFactory());
    }

    public void setEncoding(String encoding) {
        if (StrKit.isBlank(encoding)) {
            throw new IllegalArgumentException("encoding can not be blank.");
        }
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setControllerFactory(ControllerFactory controllerFactory) {
        if (controllerFactory == null) {
            throw new IllegalArgumentException("controllerFactory can not be null.");
        }
        this.controllerFactory = controllerFactory;
    }

    public ControllerFactory getControllerFactory() {
        this.controllerFactory.setInjectDependency(this.getInjectDependency());
        return this.controllerFactory;
    }

    public void setInjectDependency(boolean injectDependency) {
        AopManager.me().setInjectDependency(injectDependency);
    }

    public boolean getInjectDependency() {
        return AopManager.me().isInjectDependency();
    }

    public void setInjectSuperClass(boolean injectSuperClass) {
        AopManager.me().setInjectSuperClass(injectSuperClass);
    }

    public boolean getInjectSuperClass() {
        return AopManager.me().isInjectSuperClass();
    }

    public void setTokenCache(ITokenCache tokenCache) {
        this.tokenCache = tokenCache;
    }

    public ITokenCache getTokenCache() {
        return this.tokenCache;
    }

    public String getUrlParaSeparator() {
        return this.urlParaSeparator;
    }

    public ViewType getViewType() {
        return this.viewType;
    }

    public void setViewType(ViewType viewType) {
        if (viewType == null) {
            throw new IllegalArgumentException("viewType can not be null");
        }
        this.viewType = viewType;
    }

    public void setUrlParaSeparator(String urlParaSeparator) {
        if (StrKit.isBlank(urlParaSeparator) || urlParaSeparator.contains("/")) {
            throw new IllegalArgumentException("urlParaSepartor can not be blank and can not contains \"/\"");
        }
        this.urlParaSeparator = urlParaSeparator;
    }

    public String getViewExtension() {
        return this.viewExtension;
    }

    public void setViewExtension(String viewExtension) {
        this.viewExtension = viewExtension.startsWith(".") ? viewExtension : "." + viewExtension;
    }

    public void setError404View(String error404View) {
        this.setErrorView(404, error404View);
    }

    public void setError500View(String error500View) {
        this.setErrorView(500, error500View);
    }

    public void setError401View(String error401View) {
        this.setErrorView(401, error401View);
    }

    public void setError403View(String error403View) {
        this.setErrorView(403, error403View);
    }

    public void setErrorView(int errorCode, String errorView) {
        ErrorRender.setErrorView(errorCode, errorView);
    }

    public void setErrorJsonContent(int errorCode, String errorJsonContent) {
        ErrorRender.setErrorJsonContent(errorCode, errorJsonContent);
    }

    public void setErrorHtmlContent(int errorCode, String errorHtmlContent) {
        ErrorRender.setErrorHtmlContent(errorCode, errorHtmlContent);
    }

    public String getBaseDownloadPath() {
        return this.baseDownloadPath;
    }

    public void setBaseDownloadPath(String baseDownloadPath) {
        if (StrKit.isBlank(baseDownloadPath)) {
            throw new IllegalArgumentException("baseDownloadPath can not be blank.");
        }
        this.baseDownloadPath = baseDownloadPath;
    }

    public void setBaseUploadPath(String baseUploadPath) {
        if (StrKit.isBlank(baseUploadPath)) {
            throw new IllegalArgumentException("baseUploadPath can not be blank.");
        }
        this.baseUploadPath = baseUploadPath;
    }

    public String getBaseUploadPath() {
        return this.baseUploadPath;
    }

    public long getMaxPostSize() {
        return this.maxPostSize;
    }

    public void setMaxPostSize(long maxPostSize) {
        this.maxPostSize = maxPostSize;
    }

    public void setI18nDefaultBaseName(String defaultBaseName) {
        I18n.setDefaultBaseName(defaultBaseName);
    }

    public void setI18nDefaultLocale(String defaultLocale) {
        I18n.setDefaultLocale(defaultLocale);
    }

    public void setReportAfterInvocation(boolean reportAfterInvocation) {
        ActionReporter.setReportAfterInvocation(reportAfterInvocation);
    }

    public void setFreeMarkerTemplateUpdateDelay(int delayInSeconds) {
        if (delayInSeconds < 0) {
            throw new IllegalArgumentException("template_update_delay must more than -1.");
        }
        this.freeMarkerTemplateUpdateDelay = delayInSeconds;
    }

    public int getFreeMarkerTemplateUpdateDelay() {
        return this.freeMarkerTemplateUpdateDelay;
    }

    public void setDenyAccessJsp(boolean denyAccessJsp) {
        this.denyAccessJsp = denyAccessJsp;
    }

    public boolean getDenyAccessJsp() {
        return this.denyAccessJsp;
    }

    public void setActionReporter(ActionReporter actionReporter) {
        this.actionReporter = actionReporter;
    }

    public ActionReporter getActionReporter() {
        return this.actionReporter;
    }

    public void setToJavaAwtHeadless() {
        System.setProperty("java.awt.headless", "true");
    }

    public void setResolveJsonRequest(boolean resolveJsonRequest) {
        ParaProcessor.setResolveJson(resolveJsonRequest);
    }

    public void setJsonRequestFactory(BiFunction<String, HttpServletRequest, JsonRequest> jsonRequestFactory) {
        ParaProcessor.setJsonRequestFactory(jsonRequestFactory);
    }

    public void setActionMapping(Function<Routes, ActionMapping> func) {
        this.actionMappingFunc = func;
    }

    public Function<Routes, ActionMapping> getActionMappingFunc() {
        return this.actionMappingFunc;
    }
}

