/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.core;

import com.jfinal.kit.StrKit;
import com.jfinal.render.ErrorRender;
import com.jfinal.render.Render;
import com.jfinal.render.RenderManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ActionException
extends RuntimeException {
    private static final long serialVersionUID = 1998063243843477017L;
    private int errorCode;
    private Render errorRender;

    public ActionException(int errorCode, Render errorRender) {
        this.init(errorCode, errorRender);
    }

    private void init(final int errorCode, final Render errorRender) {
        if (errorRender == null) {
            throw new IllegalArgumentException("The parameter errorRender can not be null.");
        }
        this.errorCode = errorCode;
        this.errorRender = errorRender instanceof ErrorRender ? errorRender : new Render(){

            @Override
            public Render setContext(HttpServletRequest req, HttpServletResponse res, String viewPath) {
                errorRender.setContext(req, res, viewPath);
                res.setStatus(errorCode);
                return this;
            }

            @Override
            public void render() {
                errorRender.render();
            }
        };
    }

    public ActionException(int errorCode, String viewOrJson) {
        if (StrKit.isBlank(viewOrJson)) {
            throw new IllegalArgumentException("The parameter viewOrJson can not be blank.");
        }
        this.errorCode = errorCode;
        this.errorRender = RenderManager.me().getRenderFactory().getErrorRender(errorCode, viewOrJson);
    }

    public ActionException(int errorCode, Render errorRender, String errorMessage) {
        super(errorMessage);
        this.init(errorCode, errorRender);
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public Render getErrorRender() {
        return this.errorRender;
    }

    @Override
    public Throwable fillInStackTrace() {
        return this;
    }
}

