/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.core;

import com.jfinal.config.Routes;
import com.jfinal.core.Controller;
import com.jfinal.core.Path;
import com.jfinal.kit.StrKit;
import com.jfinal.log.Log;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Modifier;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class PathScanner {
    private static final Set<Class<?>> scannedController = new HashSet();
    private static Predicate<URL> resourceFilter = null;
    private String basePackage;
    private Predicate<String> classSkip;
    private Routes routes;
    private ClassLoader classLoader;

    public PathScanner(String basePackage, Routes routes, Predicate<String> classSkip) {
        if (StrKit.isBlank(basePackage)) {
            throw new IllegalArgumentException("basePackage can not be blank");
        }
        if (routes == null) {
            throw new IllegalArgumentException("routes can not be null");
        }
        String bp = basePackage.replace('.', '/');
        bp = bp.endsWith("/") ? bp : bp + '/';
        this.basePackage = bp = bp.startsWith("/") ? bp.substring(1) : bp;
        this.routes = routes;
        this.classSkip = classSkip;
    }

    public PathScanner(String basePackage, Routes routes) {
        this(basePackage, routes, null);
    }

    public static void filter(Predicate<URL> resourceFilter) {
        PathScanner.resourceFilter = resourceFilter;
    }

    public void scan() {
        try {
            this.classLoader = this.getClassLoader();
            List<URL> urlList = this.getResources();
            this.scanResources(urlList);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private ClassLoader getClassLoader() {
        ClassLoader ret = Thread.currentThread().getContextClassLoader();
        return ret != null ? ret : PathScanner.class.getClassLoader();
    }

    private List<URL> getResources() throws IOException {
        ArrayList<URL> ret = new ArrayList<URL>();
        HashSet<String> urlSet = new HashSet<String>();
        Enumeration<URL> urls = this.classLoader.getResources(this.basePackage);
        while (urls.hasMoreElements()) {
            String urlStr;
            URL url = urls.nextElement();
            if (resourceFilter != null && !resourceFilter.test(url) || urlSet.contains(urlStr = url.toString())) continue;
            urlSet.add(urlStr);
            ret.add(url);
        }
        return ret;
    }

    private void scanResources(List<URL> urlList) throws IOException {
        for (URL url : urlList) {
            String protocol = url.getProtocol();
            if ("jar".equals(protocol)) {
                this.scanJar(url);
                continue;
            }
            if (!"file".equals(protocol)) continue;
            this.scanFile(url);
        }
    }

    private void scanJar(URL url) throws IOException {
        URLConnection urlConn = url.openConnection();
        if (urlConn instanceof JarURLConnection) {
            JarURLConnection jarUrlConn = (JarURLConnection)urlConn;
            try (JarFile jarFile = jarUrlConn.getJarFile();){
                Enumeration<JarEntry> jarFileEntries = jarFile.entries();
                while (jarFileEntries.hasMoreElements()) {
                    JarEntry jarEntry = jarFileEntries.nextElement();
                    String en = jarEntry.getName();
                    if (!en.endsWith(".class") || !en.startsWith(this.basePackage)) continue;
                    en = en.substring(0, en.length() - 6).replace('/', '.');
                    this.scanController(en);
                }
            }
        }
    }

    private void scanFile(URL url) {
        String path = url.getPath();
        path = this.decodeUrl(path);
        File file = new File(path);
        String classPath = this.getClassPath(file);
        this.scanFile(file, classPath);
    }

    private void scanFile(File file, String classPath) {
        String fullName;
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files != null) {
                for (File fi : files) {
                    this.scanFile(fi, classPath);
                }
            }
        } else if (file.isFile() && (fullName = file.getAbsolutePath()) != null && fullName.endsWith(".class")) {
            String className = fullName.substring(classPath.length(), fullName.length() - 6).replace(File.separatorChar, '.');
            this.scanController(className);
        }
    }

    private String getClassPath(File file) {
        String bp;
        int index;
        String ret = file.getAbsolutePath();
        if (!ret.endsWith(File.separator)) {
            ret = ret + File.separator;
        }
        if ((index = ret.lastIndexOf(bp = this.basePackage.replace('/', File.separatorChar))) != -1) {
            ret = ret.substring(0, index);
        }
        return ret;
    }

    private void scanController(String className) {
        if (this.classSkip != null && this.classSkip.test(className)) {
            return;
        }
        Class<?> c = this.loadClass(className);
        if (c != null && Controller.class.isAssignableFrom(c) && !scannedController.contains(c)) {
            Path path;
            scannedController.add(c);
            int mod = c.getModifiers();
            if (Modifier.isPublic(mod) && !Modifier.isAbstract(mod) && (path = c.getAnnotation(Path.class)) != null) {
                String viewPath = path.viewPath();
                if ("*".equals(viewPath)) {
                    this.routes.add(path.value(), c);
                } else {
                    this.routes.add(path.value(), c, viewPath);
                }
            }
        }
    }

    private Class<?> loadClass(String className) {
        try {
            return this.classLoader.loadClass(className);
        }
        catch (Throwable t) {
            Log.getLog(PathScanner.class).debug("PathScanner can not load the class \"" + className + "\"");
            return null;
        }
    }

    private String decodeUrl(String url) {
        try {
            return URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

