/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.core.paragetter;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jfinal.core.Action;
import com.jfinal.core.Controller;
import com.jfinal.core.paragetter.JsonRequest;
import com.jfinal.core.paragetter.ParaGetter;
import com.jfinal.core.paragetter.ParaProcessor;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class BeanGetter<T>
extends ParaGetter<T> {
    private final Class<T> beanClass;
    private final Class<?> parameterizedType;

    public BeanGetter(Class<T> beanClass, String parameterName, Parameter parameter) {
        super(parameterName, null);
        this.beanClass = beanClass;
        this.parameterizedType = this.getParameterizedType(parameter);
    }

    private Class<?> getParameterizedType(Parameter parameter) {
        Type[] ts;
        Type type;
        if (parameter != null && (type = parameter.getParameterizedType()) instanceof ParameterizedType && (ts = ((ParameterizedType)type).getActualTypeArguments()) != null && ts.length > 0) {
            return ts[0] instanceof Class ? (Class)ts[0] : null;
        }
        return null;
    }

    @Override
    public T get(Action action, Controller c) {
        if (ParaProcessor.resolveJson && c.isJsonRequest()) {
            return this.resolveJson((JsonRequest)c.getRequest());
        }
        return c.getBean(this.beanClass, this.getParameterName(), true);
    }

    private T resolveJson(JsonRequest req) {
        JSONObject jsonObj = req.getJSONObject();
        if (jsonObj == null) {
            return this.toList(req.getJSONArray());
        }
        String paraName = this.getParameterName();
        if (jsonObj.containsKey((Object)paraName)) {
            return (T)jsonObj.getObject(paraName, this.beanClass);
        }
        return (T)jsonObj.toJavaObject(this.beanClass);
    }

    private T toList(JSONArray jsonArr) {
        if (jsonArr == null) {
            return null;
        }
        if (this.parameterizedType != null) {
            return (T)jsonArr.toJavaList(this.parameterizedType);
        }
        return (T)jsonArr.toJavaList(Object.class);
    }

    @Override
    protected T to(String v) {
        return null;
    }
}

