/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.core.paragetter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;

public class JsonRequest
implements HttpServletRequest {
    private JSONObject jsonObject;
    private JSONArray jsonArray;
    private HttpServletRequest req;
    private HashMap<String, String[]> paraMap;

    public JsonRequest(String jsonString, HttpServletRequest req) {
        Object json = JSON.parse((String)jsonString);
        if (json instanceof JSONObject) {
            this.jsonObject = (JSONObject)json;
        } else if (json instanceof JSONArray) {
            this.jsonArray = (JSONArray)json;
        }
        this.req = req;
    }

    public JSONObject getJSONObject() {
        return this.jsonObject;
    }

    public JSONArray getJSONArray() {
        return this.jsonArray;
    }

    public HttpServletRequest getInnerRequest() {
        return this.req;
    }

    public boolean isJSONObject() {
        return this.jsonObject != null;
    }

    public boolean isJSONArray() {
        return this.jsonArray != null;
    }

    private HashMap<String, String[]> getParaMap() {
        if (this.paraMap == null) {
            this.paraMap = this.jsonObject != null ? this.createParaMap(this.jsonObject) : new HashMap();
        }
        return this.paraMap;
    }

    private HashMap<String, String[]> createParaMap(JSONObject jsonPara) {
        HashMap<String, String[]> newPara = new HashMap<String, String[]>();
        Map oldPara = this.req.getParameterMap();
        if (oldPara != null && oldPara.size() > 0) {
            newPara.putAll(oldPara);
        }
        for (Map.Entry e : jsonPara.entrySet()) {
            String key = (String)e.getKey();
            Object value = e.getValue();
            if (value instanceof JSON) {
                newPara.put(key, new String[]{((JSON)value).toJSONString()});
                continue;
            }
            if (value != null) {
                newPara.put(key, new String[]{value.toString()});
                continue;
            }
            newPara.put(key, null);
        }
        return newPara;
    }

    public String getParameter(String name) {
        if (this.jsonObject != null && this.jsonObject.containsKey((Object)name)) {
            Object value = this.jsonObject.get((Object)name);
            if (value instanceof JSON) {
                return ((JSON)value).toJSONString();
            }
            if (value != null) {
                return value.toString();
            }
            return null;
        }
        return this.req.getParameter(name);
    }

    public Map<String, String[]> getParameterMap() {
        return this.getParaMap();
    }

    public String[] getParameterValues(String name) {
        return this.getParaMap().get(name);
    }

    public Enumeration<String> getParameterNames() {
        if (this.jsonObject != null) {
            return Collections.enumeration(this.jsonObject.keySet());
        }
        return Collections.emptyEnumeration();
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.req.getInputStream();
    }

    public BufferedReader getReader() throws IOException {
        return this.req.getReader();
    }

    public Object getAttribute(String name) {
        return this.req.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        return this.req.getAttributeNames();
    }

    public String getCharacterEncoding() {
        return this.req.getCharacterEncoding();
    }

    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        this.req.setCharacterEncoding(env);
    }

    public int getContentLength() {
        return this.req.getContentLength();
    }

    public long getContentLengthLong() {
        return this.req.getContentLengthLong();
    }

    public String getContentType() {
        return this.req.getContentType();
    }

    public String getProtocol() {
        return this.req.getProtocol();
    }

    public String getScheme() {
        return this.req.getScheme();
    }

    public String getServerName() {
        return this.req.getServerName();
    }

    public int getServerPort() {
        return this.req.getServerPort();
    }

    public String getRemoteAddr() {
        return this.req.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.req.getRemoteHost();
    }

    public void setAttribute(String name, Object o) {
        this.req.setAttribute(name, o);
    }

    public void removeAttribute(String name) {
        this.req.removeAttribute(name);
    }

    public Locale getLocale() {
        return this.req.getLocale();
    }

    public Enumeration<Locale> getLocales() {
        return this.req.getLocales();
    }

    public boolean isSecure() {
        return this.req.isSecure();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return this.req.getRequestDispatcher(path);
    }

    public String getRealPath(String path) {
        return this.req.getRealPath(path);
    }

    public int getRemotePort() {
        return this.req.getRemotePort();
    }

    public String getLocalName() {
        return this.req.getLocalName();
    }

    public String getLocalAddr() {
        return this.req.getLocalAddr();
    }

    public int getLocalPort() {
        return this.req.getLocalPort();
    }

    public ServletContext getServletContext() {
        return this.req.getServletContext();
    }

    public AsyncContext startAsync() throws IllegalStateException {
        return this.req.startAsync();
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        return this.req.startAsync(servletRequest, servletResponse);
    }

    public boolean isAsyncStarted() {
        return this.req.isAsyncStarted();
    }

    public boolean isAsyncSupported() {
        return this.req.isAsyncSupported();
    }

    public AsyncContext getAsyncContext() {
        return this.req.getAsyncContext();
    }

    public DispatcherType getDispatcherType() {
        return this.req.getDispatcherType();
    }

    public String getAuthType() {
        return this.req.getAuthType();
    }

    public Cookie[] getCookies() {
        return this.req.getCookies();
    }

    public long getDateHeader(String name) {
        return this.req.getDateHeader(name);
    }

    public String getHeader(String name) {
        return this.req.getHeader(name);
    }

    public Enumeration<String> getHeaders(String name) {
        return this.req.getHeaders(name);
    }

    public Enumeration<String> getHeaderNames() {
        return this.req.getHeaderNames();
    }

    public int getIntHeader(String name) {
        return this.req.getIntHeader(name);
    }

    public String getMethod() {
        return this.req.getMethod();
    }

    public String getPathInfo() {
        return this.req.getPathInfo();
    }

    public String getPathTranslated() {
        return this.req.getPathTranslated();
    }

    public String getContextPath() {
        return this.req.getContextPath();
    }

    public String getQueryString() {
        return this.req.getQueryString();
    }

    public String getRemoteUser() {
        return this.req.getRemoteUser();
    }

    public boolean isUserInRole(String role) {
        return this.req.isUserInRole(role);
    }

    public Principal getUserPrincipal() {
        return this.req.getUserPrincipal();
    }

    public String getRequestedSessionId() {
        return this.req.getRequestedSessionId();
    }

    public String getRequestURI() {
        return this.req.getRequestURI();
    }

    public StringBuffer getRequestURL() {
        return this.req.getRequestURL();
    }

    public String getServletPath() {
        return this.req.getServletPath();
    }

    public HttpSession getSession(boolean create) {
        return this.req.getSession(create);
    }

    public HttpSession getSession() {
        return this.req.getSession();
    }

    public String changeSessionId() {
        return this.req.changeSessionId();
    }

    public boolean isRequestedSessionIdValid() {
        return this.req.isRequestedSessionIdValid();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.req.isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.req.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.req.isRequestedSessionIdFromUrl();
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        return this.req.authenticate(response);
    }

    public void login(String username, String password) throws ServletException {
        this.req.login(username, password);
    }

    public void logout() throws ServletException {
        this.req.logout();
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        return this.req.getParts();
    }

    public Part getPart(String name) throws IOException, ServletException {
        return this.req.getPart(name);
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> handlerClass) throws IOException, ServletException {
        return (T)this.req.upgrade(handlerClass);
    }
}

