/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.core.paragetter;

import com.jfinal.core.Action;
import com.jfinal.core.Controller;
import com.jfinal.core.paragetter.FileGetter;
import com.jfinal.core.paragetter.IParaGetter;
import com.jfinal.core.paragetter.JsonRequest;
import com.jfinal.core.paragetter.UploadFileGetter;
import java.util.function.BiFunction;
import javax.servlet.http.HttpServletRequest;

public class ParaProcessor
implements IParaGetter<Object[]> {
    static boolean resolveJson = false;
    private static BiFunction<String, HttpServletRequest, JsonRequest> jsonRequestFactory = (jsonString, req) -> new JsonRequest((String)jsonString, (HttpServletRequest)req);
    private int fileParaIndex = -1;
    private IParaGetter<?>[] paraGetters;

    public static void setResolveJson(boolean resolveJson) {
        ParaProcessor.resolveJson = resolveJson;
    }

    public static void setJsonRequestFactory(BiFunction<String, HttpServletRequest, JsonRequest> jsonRequestFactory) {
        ParaProcessor.jsonRequestFactory = jsonRequestFactory;
    }

    public ParaProcessor(int paraCount) {
        this.paraGetters = paraCount > 0 ? new IParaGetter[paraCount] : null;
    }

    public void addParaGetter(int index, IParaGetter<?> paraGetter) {
        if (this.fileParaIndex == -1 && (paraGetter instanceof FileGetter || paraGetter instanceof UploadFileGetter)) {
            this.fileParaIndex = index;
        }
        this.paraGetters[index] = paraGetter;
    }

    @Override
    public Object[] get(Action action, Controller c) {
        if (resolveJson && c.isJsonRequest()) {
            c.setHttpServletRequest(jsonRequestFactory.apply(c.getRawData(), c.getRequest()));
        }
        int len = this.paraGetters.length;
        Object[] ret = new Object[len];
        if (this.fileParaIndex == -1) {
            for (int i = 0; i < len; ++i) {
                ret[i] = this.paraGetters[i].get(action, c);
            }
            return ret;
        }
        Object fileRet = this.paraGetters[this.fileParaIndex].get(action, c);
        for (int i = 0; i < len; ++i) {
            ret[i] = i != this.fileParaIndex ? this.paraGetters[i].get(action, c) : fileRet;
        }
        return ret;
    }
}

