/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.interceptor;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;
import com.jfinal.core.Controller;
import java.util.HashSet;
import java.util.Set;

public class Restful
implements Interceptor {
    private static final String isRestfulForwardKey = "_isRestfulForward";
    private Set<String> set = new HashSet<String>(){
        private static final long serialVersionUID = 2717581127375143508L;
        {
            this.add("show");
            this.add("save");
            this.add("update");
            this.add("delete");
        }
    };

    @Override
    public void intercept(Invocation inv) {
        Controller controller = inv.getController();
        Boolean isRestfulForward = (Boolean)controller.getAttr(isRestfulForwardKey);
        String methodName = inv.getMethodName();
        if (this.set.contains(methodName) && isRestfulForward == null) {
            inv.getController().renderError(404);
            return;
        }
        if (isRestfulForward != null && isRestfulForward.booleanValue()) {
            inv.invoke();
            return;
        }
        String controllerPath = inv.getControllerPath();
        String method = controller.getRequest().getMethod().toUpperCase();
        String urlPara = controller.getPara();
        if ("GET".equals(method)) {
            if (urlPara != null && !"edit".equals(methodName)) {
                controller.setAttr(isRestfulForwardKey, Boolean.TRUE);
                controller.forwardAction(controllerPath + "/show/" + urlPara);
                return;
            }
        } else {
            if ("POST".equals(method)) {
                controller.setAttr(isRestfulForwardKey, Boolean.TRUE);
                controller.forwardAction(controllerPath + "/save");
                return;
            }
            if ("PUT".equals(method)) {
                controller.setAttr(isRestfulForwardKey, Boolean.TRUE);
                controller.forwardAction(controllerPath + "/update/" + urlPara);
                return;
            }
            if ("DELETE".equals(method)) {
                controller.setAttr(isRestfulForwardKey, Boolean.TRUE);
                controller.forwardAction(controllerPath + "/delete/" + urlPara);
                return;
            }
        }
        inv.invoke();
    }
}

