/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.json;

import com.jfinal.json.JFinalJsonKit;
import com.jfinal.json.Json;
import java.util.function.Function;

public class JFinalJson
extends Json {
    protected static final JFinalJsonKit kit = JFinalJsonKit.me;
    protected static final ThreadLocal<JFinalJsonKit.JsonResult> TL = ThreadLocal.withInitial(() -> new JFinalJsonKit.JsonResult());
    protected static int defaultConvertDepth = 16;
    protected int convertDepth = defaultConvertDepth;
    protected String timestampPattern = "yyyy-MM-dd HH:mm:ss";

    public static JFinalJson getJson() {
        return new JFinalJson();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toJson(Object object) {
        if (object == null) {
            return "null";
        }
        JFinalJsonKit.JsonResult ret = TL.get();
        try {
            if (ret.isInUse()) {
                ret = new JFinalJsonKit.JsonResult();
            }
            String dp = this.datePattern != null ? this.datePattern : this.getDefaultDatePattern();
            ret.init(dp, this.timestampPattern);
            JFinalJsonKit.ToJson<?> toJson = kit.getToJson(object);
            toJson.toJson(object, this.convertDepth, ret);
            String string = ret.toString();
            return string;
        }
        finally {
            ret.clear();
        }
    }

    public static void addToJson(Class<?> type, JFinalJsonKit.ToJson<?> toJson) {
        JFinalJsonKit.addToJson(type, toJson);
    }

    public static void setDefaultConvertDepth(int defaultConvertDepth) {
        if (defaultConvertDepth < 2) {
            throw new IllegalArgumentException("defaultConvertDepth depth can not less than 2.");
        }
        JFinalJson.defaultConvertDepth = defaultConvertDepth;
    }

    public JFinalJson setConvertDepth(int convertDepth) {
        if (convertDepth < 2) {
            throw new IllegalArgumentException("convert depth can not less than 2.");
        }
        this.convertDepth = convertDepth;
        return this;
    }

    public JFinalJson setTimestampPattern(String timestampPattern) {
        this.timestampPattern = timestampPattern;
        return this;
    }

    public static void setMaxBufferSize(int maxBufferSize) {
        JFinalJsonKit.setMaxBufferSize(maxBufferSize);
    }

    public static void setTreatModelAsBean(boolean treatModelAsBean) {
        JFinalJsonKit.setTreatModelAsBean(treatModelAsBean);
    }

    public static void setModelAndRecordFieldNameConverter(Function<String, String> converter) {
        JFinalJsonKit.setModelAndRecordFieldNameConverter(converter);
    }

    public static void setModelAndRecordFieldNameToCamelCase(boolean toLowerCaseAnyway) {
        JFinalJsonKit.setModelAndRecordFieldNameToCamelCase(toLowerCaseAnyway);
    }

    public static void setModelAndRecordFieldNameToCamelCase() {
        JFinalJsonKit.setModelAndRecordFieldNameToCamelCase();
    }

    public static void setToJsonFactory(Function<Object, JFinalJsonKit.ToJson<?>> toJsonFactory) {
        JFinalJsonKit.setToJsonFactory(toJsonFactory);
    }

    public static void setSkipNullValueField(boolean skipNullValueField) {
        JFinalJsonKit.setSkipNullValueField(skipNullValueField);
    }

    @Override
    public <T> T parse(String jsonString, Class<T> type) {
        throw new RuntimeException("jfinal 5.0.0\u9ed8\u8ba4 json \u5b9e\u73b0\u6682\u4e0d\u652f\u6301 json \u5230 object \u7684\u8f6c\u6362,\u5efa\u8bae\u4f7f\u7528 active recrord \u7684 Generator \u751f\u6210 base model\uff0c\u518d\u901a\u8fc7 me.setJsonFactory(new MixedJsonFactory()) \u6765\u652f\u6301");
    }
}

