/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.kit;

import java.nio.charset.Charset;

public class Base64Kit {
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    private static IBase64 delegate = new Base64();

    private Base64Kit() {
    }

    public static String encode(byte[] value) {
        return delegate.encode(value);
    }

    public static String encode(String value) {
        byte[] val = value.getBytes(UTF_8);
        return delegate.encode(val);
    }

    public static String encode(String value, String charsetName) {
        byte[] val = value.getBytes(Charset.forName(charsetName));
        return delegate.encode(val);
    }

    public static byte[] decode(String value) {
        return delegate.decode(value);
    }

    public static String decodeToStr(String value) {
        byte[] decodedValue = delegate.decode(value);
        return new String(decodedValue, UTF_8);
    }

    public static String decodeToStr(String value, String charsetName) {
        byte[] decodedValue = delegate.decode(value);
        return new String(decodedValue, Charset.forName(charsetName));
    }

    static class Base64
    implements IBase64 {
        Base64() {
        }

        @Override
        public String encode(byte[] value) {
            return java.util.Base64.getEncoder().encodeToString(value);
        }

        @Override
        public byte[] decode(String value) {
            return java.util.Base64.getDecoder().decode(value);
        }
    }

    static interface IBase64 {
        public String encode(byte[] var1);

        public byte[] decode(String var1);
    }
}

