/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.kit;

import com.jfinal.json.Json;
import com.jfinal.kit.Func;
import com.jfinal.kit.StrKit;
import java.util.HashMap;
import java.util.Map;

public class Ret
extends HashMap {
    private static final long serialVersionUID = -2150729333382285526L;
    static String STATE = "state";
    static Object STATE_OK = "ok";
    static Object STATE_FAIL = "fail";
    static Func.F30<Ret, String, Object> stateWatcher = null;
    static Func.F21<Boolean, Object, Boolean> okFailHandler = null;
    static String DATA = "data";
    static boolean dataWithOkState = false;
    static String MSG = "msg";

    public static Ret of(Object key, Object value) {
        return new Ret().set(key, value);
    }

    public static Ret by(Object key, Object value) {
        return new Ret().set(key, value);
    }

    public static Ret create() {
        return new Ret();
    }

    public static Ret ok() {
        return new Ret().setOk();
    }

    public static Ret ok(String msg) {
        return new Ret().setOk()._setMsg(msg);
    }

    public static Ret ok(Object key, Object value) {
        return new Ret().setOk().set(key, value);
    }

    public static Ret fail() {
        return new Ret().setFail();
    }

    public static Ret fail(String msg) {
        return new Ret().setFail()._setMsg(msg);
    }

    @Deprecated
    public static Ret fail(Object key, Object value) {
        return new Ret().setFail().set(key, value);
    }

    public static Ret state(Object value) {
        return new Ret()._setState(value);
    }

    public static Ret data(Object data) {
        return new Ret()._setData(data);
    }

    public static Ret msg(String msg) {
        return new Ret()._setMsg(msg);
    }

    protected Ret _setState(Object value) {
        super.put(STATE, value);
        if (stateWatcher != null) {
            stateWatcher.call(this, STATE, value);
        }
        return this;
    }

    protected Ret _setData(Object data) {
        super.put(DATA, data);
        if (dataWithOkState) {
            this._setState(STATE_OK);
        }
        return this;
    }

    protected Ret _setMsg(String msg) {
        super.put(MSG, msg);
        return this;
    }

    public Ret setOk() {
        return this._setState(STATE_OK);
    }

    public Ret setFail() {
        return this._setState(STATE_FAIL);
    }

    public boolean isOk() {
        Object state = this.get(STATE);
        if (STATE_OK.equals(state)) {
            return true;
        }
        if (STATE_FAIL.equals(state)) {
            return false;
        }
        if (okFailHandler != null) {
            return okFailHandler.call(Boolean.TRUE, state);
        }
        throw new IllegalStateException("\u8c03\u7528 isOk() \u4e4b\u524d\uff0c\u5fc5\u987b\u5148\u8c03\u7528 ok()\u3001fail() \u6216\u8005 setOk()\u3001setFail() \u65b9\u6cd5");
    }

    public boolean isFail() {
        Object state = this.get(STATE);
        if (STATE_FAIL.equals(state)) {
            return true;
        }
        if (STATE_OK.equals(state)) {
            return false;
        }
        if (okFailHandler != null) {
            return okFailHandler.call(Boolean.FALSE, state);
        }
        throw new IllegalStateException("\u8c03\u7528 isFail() \u4e4b\u524d\uff0c\u5fc5\u987b\u5148\u8c03\u7528 ok()\u3001fail() \u6216\u8005 setOk()\u3001setFail() \u65b9\u6cd5");
    }

    public Ret set(Object key, Object value) {
        super.put(key, value);
        return this;
    }

    public Ret setIfNotBlank(Object key, String value) {
        if (StrKit.notBlank(value)) {
            this.set(key, value);
        }
        return this;
    }

    public Ret setIfNotNull(Object key, Object value) {
        if (value != null) {
            this.set(key, value);
        }
        return this;
    }

    public Ret set(Map map) {
        super.putAll(map);
        return this;
    }

    public Ret set(Ret ret) {
        super.putAll(ret);
        return this;
    }

    public Ret delete(Object key) {
        super.remove(key);
        return this;
    }

    public <T> T getAs(Object key) {
        return (T)this.get(key);
    }

    public String getStr(Object key) {
        Object s = this.get(key);
        return s != null ? s.toString() : null;
    }

    public Integer getInt(Object key) {
        Number n = (Number)this.get(key);
        return n != null ? Integer.valueOf(n.intValue()) : null;
    }

    public Long getLong(Object key) {
        Number n = (Number)this.get(key);
        return n != null ? Long.valueOf(n.longValue()) : null;
    }

    public Double getDouble(Object key) {
        Number n = (Number)this.get(key);
        return n != null ? Double.valueOf(n.doubleValue()) : null;
    }

    public Float getFloat(Object key) {
        Number n = (Number)this.get(key);
        return n != null ? Float.valueOf(n.floatValue()) : null;
    }

    public Number getNumber(Object key) {
        return (Number)this.get(key);
    }

    public Boolean getBoolean(Object key) {
        return (Boolean)this.get(key);
    }

    public boolean notNull(Object key) {
        return this.get(key) != null;
    }

    public boolean isNull(Object key) {
        return this.get(key) == null;
    }

    public boolean isTrue(Object key) {
        Object value = this.get(key);
        return value instanceof Boolean && (Boolean)value == true;
    }

    public boolean isFalse(Object key) {
        Object value = this.get(key);
        return value instanceof Boolean && (Boolean)value == false;
    }

    public String toJson() {
        return Json.getJson().toJson(this);
    }

    @Override
    public boolean equals(Object ret) {
        return ret instanceof Ret && super.equals(ret);
    }
}

