/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.log;

import com.jfinal.log.Log;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;
import org.slf4j.spi.LocationAwareLogger;

public class Slf4jLog
extends Log {
    private LocationAwareLogger log;
    private static final Object[] NULL_ARGS = new Object[0];
    private static final String callerFQCN = Slf4jLog.class.getName();

    Slf4jLog(LocationAwareLogger log) {
        this.log = log;
    }

    @Override
    public void trace(String message) {
        this.log.log(null, callerFQCN, 0, message, NULL_ARGS, null);
    }

    @Override
    public void trace(String message, Throwable t) {
        this.log.log(null, callerFQCN, 0, message, NULL_ARGS, t);
    }

    @Override
    public void debug(String message) {
        this.log.log(null, callerFQCN, 10, message, NULL_ARGS, null);
    }

    @Override
    public void debug(String message, Throwable t) {
        this.log.log(null, callerFQCN, 10, message, NULL_ARGS, t);
    }

    @Override
    public void info(String message) {
        this.log.log(null, callerFQCN, 20, message, NULL_ARGS, null);
    }

    @Override
    public void info(String message, Throwable t) {
        this.log.log(null, callerFQCN, 20, message, NULL_ARGS, t);
    }

    @Override
    public void warn(String message) {
        this.log.log(null, callerFQCN, 30, message, NULL_ARGS, null);
    }

    @Override
    public void warn(String message, Throwable t) {
        this.log.log(null, callerFQCN, 30, message, NULL_ARGS, t);
    }

    @Override
    public void error(String message) {
        this.log.log(null, callerFQCN, 40, message, NULL_ARGS, null);
    }

    @Override
    public void error(String message, Throwable t) {
        this.log.log(null, callerFQCN, 40, message, NULL_ARGS, t);
    }

    @Override
    public void fatal(String message) {
        this.log.log(null, callerFQCN, 40, message, NULL_ARGS, null);
    }

    @Override
    public void fatal(String message, Throwable t) {
        this.log.log(null, callerFQCN, 40, message, NULL_ARGS, t);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.log.isTraceEnabled();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.log.isWarnEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.log.isErrorEnabled();
    }

    @Override
    public boolean isFatalEnabled() {
        return this.log.isErrorEnabled();
    }

    @Override
    public void trace(String format, Object ... args) {
        if (this.isTraceEnabled()) {
            FormattingTuple ft = MessageFormatter.arrayFormat((String)format, (Object[])args);
            this.log.log(null, callerFQCN, 0, ft.getMessage(), NULL_ARGS, ft.getThrowable());
        }
    }

    @Override
    public void debug(String format, Object ... args) {
        if (this.isDebugEnabled()) {
            FormattingTuple ft = MessageFormatter.arrayFormat((String)format, (Object[])args);
            this.log.log(null, callerFQCN, 10, ft.getMessage(), NULL_ARGS, ft.getThrowable());
        }
    }

    @Override
    public void info(String format, Object ... args) {
        if (this.isInfoEnabled()) {
            FormattingTuple ft = MessageFormatter.arrayFormat((String)format, (Object[])args);
            this.log.log(null, callerFQCN, 20, ft.getMessage(), NULL_ARGS, ft.getThrowable());
        }
    }

    @Override
    public void warn(String format, Object ... args) {
        if (this.isWarnEnabled()) {
            FormattingTuple ft = MessageFormatter.arrayFormat((String)format, (Object[])args);
            this.log.log(null, callerFQCN, 30, ft.getMessage(), NULL_ARGS, ft.getThrowable());
        }
    }

    @Override
    public void error(String format, Object ... args) {
        if (this.isErrorEnabled()) {
            FormattingTuple ft = MessageFormatter.arrayFormat((String)format, (Object[])args);
            this.log.log(null, callerFQCN, 40, ft.getMessage(), NULL_ARGS, ft.getThrowable());
        }
    }

    @Override
    public void fatal(String format, Object ... args) {
        this.error(format, args);
    }
}

