/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.plugin.activerecord.generator;

import com.jfinal.kit.StrKit;
import com.jfinal.plugin.activerecord.dialect.Dialect;
import com.jfinal.plugin.activerecord.dialect.MysqlDialect;
import com.jfinal.plugin.activerecord.generator.ColumnMeta;
import com.jfinal.plugin.activerecord.generator.TableMeta;
import com.jfinal.plugin.activerecord.generator.TypeMapping;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import javax.sql.DataSource;

public class MetaBuilder {
    protected DataSource dataSource;
    protected Dialect dialect = new MysqlDialect();
    protected Set<String> whitelist = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    protected Set<String> blacklist = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    protected Predicate<String> tableSkip = null;
    protected Connection conn = null;
    protected DatabaseMetaData dbMeta = null;
    protected String[] removedTableNamePrefixes = null;
    protected TypeMapping typeMapping = new TypeMapping();
    protected boolean generateRemarks = false;
    protected boolean generateView = false;

    public MetaBuilder(DataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException("dataSource can not be null.");
        }
        this.dataSource = dataSource;
    }

    public void setGenerateRemarks(boolean generateRemarks) {
        this.generateRemarks = generateRemarks;
    }

    public void setGenerateView(boolean generateView) {
        this.generateView = generateView;
    }

    public void setDialect(Dialect dialect) {
        if (dialect != null) {
            this.dialect = dialect;
        }
    }

    public void addWhitelist(String ... tableNames) {
        if (tableNames != null) {
            for (String table : tableNames) {
                if (this.blacklist.contains(table = table.trim())) {
                    throw new IllegalArgumentException("\u9ed1\u540d\u5355\u4e2d\u5df2\u7ecf\u5b58\u5728\u7684 table \u4e0d\u80fd\u52a0\u5165\u767d\u540d\u5355 -> " + table);
                }
                this.whitelist.add(table);
            }
        }
    }

    public void removeWhitelist(String tableName) {
        if (tableName != null) {
            this.whitelist.remove(tableName.trim());
        }
    }

    public void addBlacklist(String ... tableNames) {
        if (tableNames != null) {
            for (String table : tableNames) {
                if (this.whitelist.contains(table = table.trim())) {
                    throw new IllegalArgumentException("\u767d\u540d\u5355\u4e2d\u5df2\u7ecf\u5b58\u5728\u7684 table \u4e0d\u80fd\u52a0\u5165\u9ed1\u540d\u5355 -> " + table);
                }
                this.blacklist.add(table);
            }
        }
    }

    public void removeBlacklist(String tableName) {
        if (tableName != null) {
            this.blacklist.remove(tableName.trim());
        }
    }

    public void addExcludedTable(String ... excludedTables) {
        this.addBlacklist(excludedTables);
    }

    public void setRemovedTableNamePrefixes(String ... removedTableNamePrefixes) {
        this.removedTableNamePrefixes = removedTableNamePrefixes;
    }

    public void setTypeMapping(TypeMapping typeMapping) {
        if (typeMapping != null) {
            this.typeMapping = typeMapping;
        }
    }

    public List<TableMeta> build() {
        System.out.println("Build TableMeta ...");
        try {
            this.conn = this.dataSource.getConnection();
            this.dbMeta = this.conn.getMetaData();
            ArrayList<TableMeta> ret = new ArrayList<TableMeta>();
            this.buildTableNames(ret);
            for (TableMeta tableMeta : ret) {
                this.buildPrimaryKey(tableMeta);
                this.buildColumnMetas(tableMeta);
            }
            this.removeNoPrimaryKeyTable(ret);
            ArrayList<TableMeta> arrayList = ret;
            return arrayList;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (this.conn != null) {
                try {
                    this.conn.close();
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    protected void removeNoPrimaryKeyTable(List<TableMeta> ret) {
        Iterator<TableMeta> it = ret.iterator();
        while (it.hasNext()) {
            TableMeta tm = it.next();
            if (!StrKit.isBlank(tm.primaryKey)) continue;
            if (this.generateView) {
                tm.primaryKey = this.dialect.getDefaultPrimaryKey();
                System.out.println("Set primaryKey \"" + tm.primaryKey + "\" for " + tm.name);
                continue;
            }
            it.remove();
            System.err.println("Skip table " + tm.name + " because there is no primary key");
        }
    }

    protected boolean isSkipTable(String tableName) {
        return false;
    }

    public MetaBuilder skip(Predicate<String> tableSkip) {
        this.tableSkip = tableSkip;
        return this;
    }

    protected String buildModelName(String tableName) {
        if (this.removedTableNamePrefixes != null) {
            for (String prefix : this.removedTableNamePrefixes) {
                if (!tableName.startsWith(prefix)) continue;
                tableName = tableName.replaceFirst(prefix, "");
                break;
            }
        }
        if (this.dialect.isOracle()) {
            tableName = tableName.toLowerCase();
        }
        return StrKit.firstCharToUpperCase(StrKit.toCamelCase(tableName));
    }

    protected String buildBaseModelName(String modelName) {
        return "Base" + modelName;
    }

    protected ResultSet getTablesResultSet() throws SQLException {
        String schemaPattern;
        String string = schemaPattern = this.dialect.isOracle() ? this.dbMeta.getUserName() : null;
        if (this.generateView) {
            return this.dbMeta.getTables(this.conn.getCatalog(), schemaPattern, null, new String[]{"TABLE", "VIEW"});
        }
        return this.dbMeta.getTables(this.conn.getCatalog(), schemaPattern, null, new String[]{"TABLE"});
    }

    protected void buildTableNames(List<TableMeta> ret) throws SQLException {
        ResultSet rs = this.getTablesResultSet();
        while (rs.next()) {
            String tableName = rs.getString("TABLE_NAME");
            if (this.whitelist.size() > 0 && !this.whitelist.contains(tableName)) {
                System.out.println("Skip table :" + tableName);
                continue;
            }
            if (this.blacklist.size() > 0 && this.blacklist.contains(tableName)) {
                System.out.println("Skip table :" + tableName);
                continue;
            }
            if (this.isSkipTable(tableName)) {
                System.out.println("Skip table :" + tableName);
                continue;
            }
            if (this.tableSkip != null && this.tableSkip.test(tableName)) {
                System.out.println("Skip table :" + tableName);
                continue;
            }
            TableMeta tableMeta = new TableMeta();
            tableMeta.name = tableName;
            tableMeta.remarks = rs.getString("REMARKS");
            tableMeta.modelName = this.buildModelName(tableName);
            tableMeta.baseModelName = this.buildBaseModelName(tableMeta.modelName);
            ret.add(tableMeta);
        }
        rs.close();
    }

    protected void buildPrimaryKey(TableMeta tableMeta) throws SQLException {
        ResultSet rs = this.dbMeta.getPrimaryKeys(this.conn.getCatalog(), null, tableMeta.name);
        String primaryKey = "";
        int index = 0;
        while (rs.next()) {
            String cn = rs.getString("COLUMN_NAME");
            if (primaryKey.equals(cn)) continue;
            if (index++ > 0) {
                primaryKey = primaryKey + ",";
            }
            primaryKey = primaryKey + cn;
        }
        tableMeta.primaryKey = primaryKey;
        rs.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildColumnMetas(TableMeta tableMeta) throws SQLException {
        String sql = this.dialect.forTableBuilderDoBuild(tableMeta.name);
        Statement stm = this.conn.createStatement();
        ResultSet rs = stm.executeQuery(sql);
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        HashMap<String, ColumnMeta> columnMetaMap = new HashMap<String, ColumnMeta>();
        if (this.generateRemarks) {
            try (ResultSet colMetaRs = null;){
                colMetaRs = this.dbMeta.getColumns(this.conn.getCatalog(), null, tableMeta.name, null);
                while (colMetaRs.next()) {
                    ColumnMeta columnMeta = new ColumnMeta();
                    columnMeta.name = colMetaRs.getString("COLUMN_NAME");
                    columnMeta.remarks = colMetaRs.getString("REMARKS");
                    columnMetaMap.put(columnMeta.name, columnMeta);
                }
            }
        }
        for (int i = 1; i <= columnCount; ++i) {
            int type;
            ColumnMeta cm = new ColumnMeta();
            cm.name = rsmd.getColumnName(i);
            String typeStr = null;
            if (this.dialect.isKeepByteAndShort()) {
                type = rsmd.getColumnType(i);
                if (type == -6) {
                    typeStr = "java.lang.Byte";
                } else if (type == 5) {
                    typeStr = "java.lang.Short";
                }
            }
            if (typeStr == null) {
                String colClassName = rsmd.getColumnClassName(i);
                typeStr = this.typeMapping.getType(colClassName);
            }
            if (typeStr == null) {
                type = rsmd.getColumnType(i);
                typeStr = type == -2 || type == -3 || type == -4 || type == 2004 ? "byte[]" : (type == 2005 || type == 2011 ? "java.lang.String" : (type == 93 || type == 91 ? "java.util.Date" : (type == 1111 ? "java.lang.Object" : "java.lang.String")));
            }
            cm.javaType = typeStr = this.handleJavaType(typeStr, rsmd, i);
            cm.attrName = this.buildAttrName(cm.name);
            if (this.generateRemarks && columnMetaMap.containsKey(cm.name)) {
                cm.remarks = ((ColumnMeta)columnMetaMap.get((Object)cm.name)).remarks;
            }
            tableMeta.columnMetas.add(cm);
        }
        rs.close();
        stm.close();
    }

    protected String handleJavaType(String typeStr, ResultSetMetaData rsmd, int column) throws SQLException {
        if (!this.dialect.isOracle()) {
            return typeStr;
        }
        if ("java.math.BigDecimal".equals(typeStr)) {
            int scale = rsmd.getScale(column);
            int precision = rsmd.getPrecision(column);
            typeStr = scale == 0 ? (precision <= 9 ? "java.lang.Integer" : (precision <= 18 ? "java.lang.Long" : "java.math.BigDecimal")) : "java.math.BigDecimal";
        }
        return typeStr;
    }

    protected String buildAttrName(String colName) {
        if (this.dialect.isOracle()) {
            colName = colName.toLowerCase();
        }
        return StrKit.toCamelCase(colName);
    }
}

