/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.plugin.ehcache;

import com.jfinal.render.FreeMarkerRender;
import com.jfinal.render.JsonRender;
import com.jfinal.render.JspRender;
import com.jfinal.render.Render;
import com.jfinal.render.TemplateRender;
import com.jfinal.render.XmlRender;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class RenderInfo
implements Serializable {
    private static final long serialVersionUID = -7299875545092102194L;
    protected String view;
    protected Integer renderType;
    protected Map<String, Object> otherPara = null;

    public RenderInfo(Render render) {
        if (render == null) {
            throw new IllegalArgumentException("Render can not be null.");
        }
        this.view = render.getView();
        if (render instanceof TemplateRender) {
            this.renderType = 0;
        } else if (render instanceof FreeMarkerRender) {
            this.renderType = 1;
        } else if (render instanceof JspRender) {
            this.renderType = 2;
        } else if (render instanceof XmlRender) {
            this.renderType = 3;
        } else if (render instanceof JsonRender) {
            JsonRender jr = (JsonRender)render;
            this.renderType = 4;
            this.otherPara = new HashMap<String, Object>();
            this.otherPara.put("jsonText", jr.getJsonText());
            this.otherPara.put("attrs", jr.getAttrs());
            this.otherPara.put("forIE", jr.getForIE());
        } else {
            throw new IllegalArgumentException("CacheInterceptor can not support the render of the type : " + render.getClass().getName());
        }
    }

    public Render createRender() {
        switch (this.renderType) {
            case 0: {
                return new TemplateRender(this.view);
            }
            case 1: {
                return new FreeMarkerRender(this.view);
            }
            case 2: {
                return new JspRender(this.view);
            }
            case 3: {
                return new XmlRender(this.view);
            }
            case 4: {
                JsonRender jr = this.otherPara.get("jsonText") != null ? new JsonRender((String)this.otherPara.get("jsonText")) : (this.otherPara.get("attrs") != null ? new JsonRender((String[])this.otherPara.get("attrs")) : new JsonRender());
                if (Boolean.TRUE.equals(this.otherPara.get("forIE"))) {
                    jr.forIE();
                }
                return jr;
            }
        }
        throw new IllegalArgumentException("CacheInterceptor can not support the renderType of the value : " + this.renderType);
    }
}

