/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.plugin.redis;

import com.jfinal.kit.StrKit;
import com.jfinal.plugin.redis.Cache;
import com.jfinal.plugin.redis.ICallback;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import redis.clients.jedis.Jedis;

public class Redis {
    static Cache mainCache = null;
    private static final ConcurrentHashMap<String, Cache> cacheMap = new ConcurrentHashMap(32, 0.5f);

    public static void addCache(Cache cache) {
        if (cache == null) {
            throw new IllegalArgumentException("cache can not be null");
        }
        if (cacheMap.containsKey(cache.getName())) {
            throw new IllegalArgumentException("The cache name already exists");
        }
        cacheMap.put(cache.getName(), cache);
        if (mainCache == null) {
            mainCache = cache;
        }
    }

    public static Cache removeCache(String cacheName) {
        return cacheMap.remove(cacheName);
    }

    public static void setMainCache(String cacheName) {
        if (StrKit.isBlank(cacheName)) {
            throw new IllegalArgumentException("cacheName can not be blank");
        }
        Cache cache = cacheMap.get(cacheName = cacheName.trim());
        if (cache == null) {
            throw new IllegalArgumentException("the cache not exists: " + cacheName);
        }
        mainCache = cache;
    }

    public static Cache use() {
        return mainCache;
    }

    public static Cache use(String cacheName) {
        return cacheMap.get(cacheName);
    }

    public static <R> R call(Function<Jedis, R> jedis) {
        return Redis.use().call(jedis);
    }

    public static <R> R call(String cacheName, Function<Jedis, R> jedis) {
        return Redis.use(cacheName).call(jedis);
    }

    public static <T> T callback(ICallback<T> callback) {
        return Redis.callback(Redis.use(), callback);
    }

    public static <T> T callback(String cacheName, ICallback<T> callback) {
        return Redis.callback(Redis.use(cacheName), callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T callback(Cache cache, ICallback<T> callback) {
        boolean notThreadLocalJedis;
        Jedis jedis = cache.getThreadLocalJedis();
        boolean bl = notThreadLocalJedis = jedis == null;
        if (notThreadLocalJedis) {
            jedis = cache.jedisPool.getResource();
            cache.setThreadLocalJedis(jedis);
        }
        try {
            T t = callback.call(cache);
            return t;
        }
        finally {
            if (notThreadLocalJedis) {
                cache.removeThreadLocalJedis();
                jedis.close();
            }
        }
    }
}

