/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.render;

import com.jfinal.kit.Okv;
import com.jfinal.render.Render;
import com.jfinal.render.RenderException;
import com.jfinal.render.RenderManager;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public class ErrorRender
extends Render {
    protected static final String contentTypeHtml = "text/html; charset=" + ErrorRender.getEncoding();
    protected static final String contentTypeJson = "application/json; charset=" + ErrorRender.getEncoding();
    protected static final String version = "<center><a href='https://gitee.com/jfinal/jfinal' target='_blank'><b>Powered by JFinal 5.0.0</b></a></center>";
    protected static final byte[] html404 = "<html><head><title>404 Not Found</title></head><body bgcolor='white'><center><h1>404 Not Found</h1></center><hr><center><a href='https://gitee.com/jfinal/jfinal' target='_blank'><b>Powered by JFinal 5.0.0</b></a></center></body></html>".getBytes();
    protected static final byte[] html500 = "<html><head><title>500 Internal Server Error</title></head><body bgcolor='white'><center><h1>500 Internal Server Error</h1></center><hr><center><a href='https://gitee.com/jfinal/jfinal' target='_blank'><b>Powered by JFinal 5.0.0</b></a></center></body></html>".getBytes();
    protected static final byte[] html400 = "<html><head><title>400 Bad Request</title></head><body bgcolor='white'><center><h1>400 Bad Request</h1></center><hr><center><a href='https://gitee.com/jfinal/jfinal' target='_blank'><b>Powered by JFinal 5.0.0</b></a></center></body></html>".getBytes();
    protected static final byte[] html401 = "<html><head><title>401 Unauthorized</title></head><body bgcolor='white'><center><h1>401 Unauthorized</h1></center><hr><center><a href='https://gitee.com/jfinal/jfinal' target='_blank'><b>Powered by JFinal 5.0.0</b></a></center></body></html>".getBytes();
    protected static final byte[] html403 = "<html><head><title>403 Forbidden</title></head><body bgcolor='white'><center><h1>403 Forbidden</h1></center><hr><center><a href='https://gitee.com/jfinal/jfinal' target='_blank'><b>Powered by JFinal 5.0.0</b></a></center></body></html>".getBytes();
    protected static final byte[] json404 = Okv.of("state", "fail").set("msg", "404 Not Found").toJson().getBytes();
    protected static final byte[] json500 = Okv.of("state", "fail").set("msg", "500 Internal Server Error").toJson().getBytes();
    protected static final byte[] json400 = Okv.of("state", "fail").set("msg", "400 Bad Request").toJson().getBytes();
    protected static final byte[] json401 = Okv.of("state", "fail").set("msg", "401 Unauthorized").toJson().getBytes();
    protected static final byte[] json403 = Okv.of("state", "fail").set("msg", "403 Forbidden").toJson().getBytes();
    protected static final Map<Integer, byte[]> errorHtmlMap = new HashMap<Integer, byte[]>();
    protected static final Map<Integer, byte[]> errorJsonMap = new HashMap<Integer, byte[]>();
    protected static final Map<Integer, String> errorViewMap = new HashMap<Integer, String>();
    protected int errorCode;
    protected String viewOrJson;

    public ErrorRender(int errorCode, String viewOrJson) {
        this.errorCode = errorCode;
        this.viewOrJson = viewOrJson;
    }

    public ErrorRender(int errorCode) {
        this.errorCode = errorCode;
    }

    public static void setErrorView(int errorCode, String errorView) {
        errorViewMap.put(errorCode, errorView);
    }

    public static String getErrorView(int errorCode) {
        return errorViewMap.get(errorCode);
    }

    public static void setErrorHtmlContent(int errorCode, String htmlContent) {
        try {
            errorHtmlMap.put(errorCode, htmlContent.getBytes(ErrorRender.getEncoding()));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setErrorJsonContent(int errorCode, String jsonContent) {
        try {
            errorJsonMap.put(errorCode, jsonContent.getBytes(ErrorRender.getEncoding()));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void render() {
        boolean isJsonContentType;
        this.response.setStatus(this.getErrorCode());
        String ct = this.request.getContentType();
        boolean bl = isJsonContentType = ct != null && ct.indexOf("json") != -1;
        if (this.viewOrJson == null && !isJsonContentType) {
            this.viewOrJson = ErrorRender.getErrorView(this.getErrorCode());
        }
        if (this.viewOrJson != null) {
            if (isJsonContentType) {
                RenderManager.me().getRenderFactory().getJsonRender(this.viewOrJson).setContext(this.request, this.response).render();
            } else {
                RenderManager.me().getRenderFactory().getRender(this.viewOrJson).setContext(this.request, this.response).render();
            }
            return;
        }
        try {
            this.response.setContentType(isJsonContentType ? contentTypeJson : contentTypeHtml);
            this.response.getOutputStream().write(isJsonContentType ? this.getErrorJson() : this.getErrorHtml());
        }
        catch (IOException e) {
            throw new RenderException(e);
        }
    }

    public byte[] getErrorHtml() {
        byte[] ret = errorHtmlMap.get(this.getErrorCode());
        return ret != null ? ret : ("<html><head><title>" + this.errorCode + " Error</title></head><body bgcolor='white'><center><h1>" + this.errorCode + " Error</h1></center><hr>" + version + "</body></html>").getBytes();
    }

    public byte[] getErrorJson() {
        byte[] ret = errorJsonMap.get(this.getErrorCode());
        return ret != null ? ret : Okv.of("state", "fail").set("msg", this.errorCode + " Error").toJson().getBytes();
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    static {
        errorHtmlMap.put(404, html404);
        errorHtmlMap.put(500, html500);
        errorHtmlMap.put(400, html400);
        errorHtmlMap.put(401, html401);
        errorHtmlMap.put(403, html403);
        errorJsonMap.put(404, json404);
        errorJsonMap.put(500, json500);
        errorJsonMap.put(400, json400);
        errorJsonMap.put(401, json401);
        errorJsonMap.put(403, json403);
    }
}

