/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.render;

import com.jfinal.captcha.CaptchaRender;
import com.jfinal.config.Constants;
import com.jfinal.render.ContentType;
import com.jfinal.render.ErrorRender;
import com.jfinal.render.FileRender;
import com.jfinal.render.FreeMarkerRender;
import com.jfinal.render.HtmlRender;
import com.jfinal.render.IRenderFactory;
import com.jfinal.render.JavascriptRender;
import com.jfinal.render.JsonRender;
import com.jfinal.render.JspRender;
import com.jfinal.render.NullRender;
import com.jfinal.render.QrCodeRender;
import com.jfinal.render.Redirect301Render;
import com.jfinal.render.RedirectRender;
import com.jfinal.render.Render;
import com.jfinal.render.TemplateRender;
import com.jfinal.render.TextRender;
import com.jfinal.render.XmlRender;
import com.jfinal.template.Engine;
import java.io.File;
import javax.servlet.ServletContext;

public class RenderFactory
implements IRenderFactory {
    protected Engine engine;
    protected Constants constants;
    protected ServletContext servletContext;
    protected MainRenderFactory mainRenderFactory;

    @Override
    public void init(Engine engine, Constants constants, ServletContext servletContext) {
        this.engine = engine;
        this.constants = constants;
        this.servletContext = servletContext;
        switch (constants.getViewType()) {
            case JFINAL_TEMPLATE: {
                this.mainRenderFactory = new MainRenderFactory();
                break;
            }
            case FREE_MARKER: {
                this.mainRenderFactory = new FreeMarkerRenderFactory();
                break;
            }
            case JSP: {
                this.mainRenderFactory = new JspRenderFactory();
            }
        }
    }

    @Override
    public Render getRender(String view) {
        return this.mainRenderFactory.getRender(view);
    }

    @Override
    public Render getTemplateRender(String view) {
        return new TemplateRender(view);
    }

    @Override
    public Render getFreeMarkerRender(String view) {
        return new FreeMarkerRender(view);
    }

    @Override
    public Render getJspRender(String view) {
        return new JspRender(view);
    }

    @Override
    public Render getJsonRender() {
        return new JsonRender();
    }

    @Override
    public Render getJsonRender(String key, Object value) {
        return new JsonRender(key, value);
    }

    @Override
    public Render getJsonRender(String[] attrs) {
        return new JsonRender(attrs);
    }

    @Override
    public Render getJsonRender(String jsonText) {
        return new JsonRender(jsonText);
    }

    @Override
    public Render getJsonRender(Object object) {
        return new JsonRender(object);
    }

    @Override
    public Render getTextRender(String text) {
        return new TextRender(text);
    }

    @Override
    public Render getTextRender(String text, String contentType) {
        return new TextRender(text, contentType);
    }

    @Override
    public Render getTextRender(String text, ContentType contentType) {
        return new TextRender(text, contentType);
    }

    @Override
    public Render getDefaultRender(String view) {
        return this.getRender(view + this.constants.getViewExtension());
    }

    @Override
    public Render getErrorRender(int errorCode, String viewOrJson) {
        return new ErrorRender(errorCode, viewOrJson);
    }

    @Override
    public Render getErrorRender(int errorCode) {
        return new ErrorRender(errorCode);
    }

    @Override
    public Render getFileRender(String fileName) {
        return new FileRender(fileName);
    }

    @Override
    public Render getFileRender(String fileName, String downloadFileName) {
        return new FileRender(fileName, downloadFileName);
    }

    @Override
    public Render getFileRender(File file) {
        return new FileRender(file);
    }

    @Override
    public Render getFileRender(File file, String downloadFileName) {
        return new FileRender(file, downloadFileName);
    }

    @Override
    public Render getRedirectRender(String url) {
        return new RedirectRender(url);
    }

    @Override
    public Render getRedirectRender(String url, boolean withQueryString) {
        return new RedirectRender(url, withQueryString);
    }

    @Override
    public Render getRedirect301Render(String url) {
        return new Redirect301Render(url);
    }

    @Override
    public Render getRedirect301Render(String url, boolean withQueryString) {
        return new Redirect301Render(url, withQueryString);
    }

    @Override
    public Render getNullRender() {
        return new NullRender();
    }

    @Override
    public Render getJavascriptRender(String jsText) {
        return new JavascriptRender(jsText);
    }

    @Override
    public Render getHtmlRender(String htmlText) {
        return new HtmlRender(htmlText);
    }

    @Override
    public Render getXmlRender(String view) {
        return new XmlRender(view);
    }

    @Override
    public Render getCaptchaRender() {
        return new CaptchaRender();
    }

    @Override
    public Render getQrCodeRender(String content, int width, int height) {
        return new QrCodeRender(content, width, height);
    }

    @Override
    public Render getQrCodeRender(String content, int width, int height, char errorCorrectionLevel) {
        return new QrCodeRender(content, width, height, errorCorrectionLevel);
    }

    private static class JspRenderFactory
    extends MainRenderFactory {
        private JspRenderFactory() {
        }

        @Override
        public Render getRender(String view) {
            return new JspRender(view);
        }
    }

    private static class FreeMarkerRenderFactory
    extends MainRenderFactory {
        private FreeMarkerRenderFactory() {
        }

        @Override
        public Render getRender(String view) {
            return new FreeMarkerRender(view);
        }
    }

    private static class MainRenderFactory {
        private MainRenderFactory() {
        }

        public Render getRender(String view) {
            return new TemplateRender(view);
        }
    }
}

